/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple4D.interfaces;

import us.ihmc.euclid.axisAngle.interfaces.AxisAngleBasics;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.RotationMatrixConversion;
import us.ihmc.euclid.rotationConversion.RotationVectorConversion;
import us.ihmc.euclid.rotationConversion.YawPitchRollConversion;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.QuaternionTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollBasics;

public interface QuaternionReadOnly
extends Tuple4DReadOnly,
Orientation3DReadOnly {
    public static final double EPS_UNITARY = 1.0E-7;

    @Override
    default public boolean containsNaN() {
        return Tuple4DReadOnly.super.containsNaN();
    }

    @Override
    default public boolean isZeroOrientation(double epsilon) {
        return QuaternionTools.isNeutralQuaternion(this, epsilon, true);
    }

    default public boolean isUnitary(double epsilon) {
        return Math.abs(this.norm() - 1.0) < epsilon;
    }

    @Override
    default public boolean isOrientation2D(double epsilon) {
        return Math.abs(this.getX()) < epsilon && Math.abs(this.getY()) < epsilon;
    }

    default public void checkIfUnitary() {
        this.checkIfUnitary(1.0E-7);
    }

    default public void checkIfUnitary(double epsilon) {
        if (!this.isUnitary(epsilon)) {
            throw new RuntimeException("This quaternion is not a unit-quaternion.");
        }
    }

    @Override
    default public double norm() {
        return EuclidCoreTools.fastSquareRoot(this.normSquared());
    }

    @Override
    default public double distance(Orientation3DReadOnly other, boolean limitToPi) {
        return QuaternionTools.distance(this, other, limitToPi);
    }

    @Override
    default public double angle(boolean limitToPi) {
        return QuaternionTools.angle(this, limitToPi);
    }

    @Deprecated
    default public double getAngle() {
        return this.angle();
    }

    @Override
    default public void get(CommonMatrix3DBasics rotationMatrixToPack) {
        RotationMatrixConversion.convertQuaternionToMatrix(this, rotationMatrixToPack);
    }

    @Override
    default public void get(AxisAngleBasics axisAngleToPack) {
        axisAngleToPack.setQuaternion(this.getX(), this.getY(), this.getZ(), this.getS());
    }

    @Override
    default public void get(QuaternionBasics quaternionToPack) {
        quaternionToPack.setQuaternion(this.getX(), this.getY(), this.getZ(), this.getS());
    }

    @Override
    default public void get(YawPitchRollBasics yawPitchRollToPack) {
        yawPitchRollToPack.setQuaternion(this.getX(), this.getY(), this.getZ(), this.getS());
    }

    @Override
    default public void getRotationVector(Vector3DBasics rotationVectorToPack) {
        RotationVectorConversion.convertQuaternionToRotationVector(this, rotationVectorToPack);
    }

    @Override
    default public void getEuler(Tuple3DBasics eulerAnglesToPack) {
        YawPitchRollConversion.convertQuaternionToYawPitchRoll(this, eulerAnglesToPack);
    }

    @Override
    default public double getYaw() {
        return YawPitchRollConversion.computeYaw(this);
    }

    @Override
    default public double getPitch() {
        return YawPitchRollConversion.computePitch(this);
    }

    @Override
    default public double getRoll() {
        return YawPitchRollConversion.computeRoll(this);
    }

    @Override
    default public void transform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.transform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void addTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.addTransform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void transform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        QuaternionTools.transform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void transform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        QuaternionTools.transform(this, matrixOriginal, matrixTransformed);
    }

    @Override
    default public void transform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        QuaternionTools.transform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed) {
        QuaternionTools.inverseTransform(this, tupleOriginal, tupleTransformed);
    }

    @Override
    default public void inverseTransform(Tuple2DReadOnly tupleOriginal, Tuple2DBasics tupleTransformed, boolean checkIfOrientation2D) {
        QuaternionTools.inverseTransform(this, tupleOriginal, tupleTransformed, checkIfOrientation2D);
    }

    @Override
    default public void inverseTransform(Vector4DReadOnly vectorOriginal, Vector4DBasics vectorTransformed) {
        QuaternionTools.inverseTransform(this, vectorOriginal, vectorTransformed);
    }

    @Override
    default public void inverseTransform(Matrix3DReadOnly matrixOriginal, Matrix3DBasics matrixTransformed) {
        QuaternionTools.inverseTransform(this, matrixOriginal, matrixTransformed);
    }
}

