/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public interface Vector2DReadOnly
extends Tuple2DReadOnly {
    @Deprecated
    default public double length() {
        return this.norm();
    }

    @Deprecated
    default public double lengthSquared() {
        return this.dot(this);
    }

    default public double angle(Vector2DReadOnly other) {
        return TupleTools.angle(this, other);
    }

    default public double cross(Tuple2DReadOnly tuple) {
        return Vector2DReadOnly.cross(this, tuple);
    }

    public static double cross(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getY() - tuple1.getY() * tuple2.getX();
    }

    @Override
    default public boolean geometricallyEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Vector2DReadOnly)) {
            return false;
        }
        Vector2DReadOnly other = (Vector2DReadOnly)geometry;
        return this.differenceNorm(other) <= epsilon;
    }
}

