/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tuple2D.interfaces;

import org.ejml.data.DMatrix;
import org.ejml.data.Matrix;
import us.ihmc.euclid.Axis2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.TupleTools;

public interface Tuple2DReadOnly
extends EuclidGeometry {
    public double getX();

    public double getY();

    default public float getX32() {
        return (float)this.getX();
    }

    default public float getY32() {
        return (float)this.getY();
    }

    default public boolean containsNaN() {
        return EuclidCoreTools.containsNaN(this.getX(), this.getY());
    }

    default public double getElement(Axis2D axis) {
        return axis.extract(this);
    }

    default public double getElement(int index) {
        switch (index) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public float getElement32(int index) {
        switch (index) {
            case 0: {
                return this.getX32();
            }
            case 1: {
                return this.getY32();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    default public void get(double[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, double[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX();
        tupleArrayToPack[startIndex] = this.getY();
    }

    default public void get(float[] tupleArrayToPack) {
        this.get(0, tupleArrayToPack);
    }

    default public void get(int startIndex, float[] tupleArrayToPack) {
        tupleArrayToPack[startIndex++] = this.getX32();
        tupleArrayToPack[startIndex] = this.getY32();
    }

    default public void get(DMatrix tupleMatrixToPack) {
        this.get(0, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, DMatrix tupleMatrixToPack) {
        this.get(startRow, 0, tupleMatrixToPack);
    }

    default public void get(int startRow, int column, DMatrix tupleMatrixToPack) {
        EuclidCoreTools.checkMatrixMinimumSize(startRow + 2, column + 1, (Matrix)tupleMatrixToPack);
        tupleMatrixToPack.unsafe_set(startRow++, column, this.getX());
        tupleMatrixToPack.unsafe_set(startRow, column, this.getY());
    }

    default public double norm() {
        return EuclidCoreTools.squareRoot(this.normSquared());
    }

    default public double normSquared() {
        return this.dot(this);
    }

    default public double differenceNorm(Tuple2DReadOnly other) {
        return EuclidCoreTools.squareRoot(this.differenceNormSquared(other));
    }

    default public double differenceNormSquared(Tuple2DReadOnly other) {
        double dx = this.getX() - other.getX();
        double dy = this.getY() - other.getY();
        return EuclidCoreTools.normSquared(dx, dy);
    }

    default public double dot(Tuple2DReadOnly other) {
        return this.getX() * other.getX() + this.getY() * other.getY();
    }

    @Override
    default public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Tuple2DReadOnly)) {
            return false;
        }
        Tuple2DReadOnly other = (Tuple2DReadOnly)geometry;
        return TupleTools.epsilonEquals(this, other, epsilon);
    }

    @Override
    default public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof Tuple2DReadOnly)) {
            return false;
        }
        Tuple2DReadOnly other = (Tuple2DReadOnly)geometry;
        if (!EuclidCoreTools.equals(this.getX(), other.getX())) {
            return false;
        }
        return EuclidCoreTools.equals(this.getY(), other.getY());
    }

    @Override
    default public String toString(String format) {
        return EuclidCoreIOTools.getTuple2DString(format, this);
    }
}

