/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.transform;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;

public class QuaternionBasedTransform
implements RigidBodyTransformBasics,
Settable<QuaternionBasedTransform> {
    private final Quaternion quaternion = new Quaternion();
    private final Vector3D translationVector = new Vector3D();

    public QuaternionBasedTransform() {
        this.setIdentity();
    }

    public QuaternionBasedTransform(RigidBodyTransformReadOnly rigidBodyTransform) {
        this.set(rigidBodyTransform);
    }

    public QuaternionBasedTransform(DMatrix matrix) {
        this.set(matrix);
    }

    public QuaternionBasedTransform(double[] array) {
        this.set(array);
    }

    public QuaternionBasedTransform(RotationMatrixReadOnly rotationMatrix, Tuple3DReadOnly translation) {
        this.set(rotationMatrix, translation);
    }

    public QuaternionBasedTransform(Orientation3DReadOnly orientation, Tuple3DReadOnly translation) {
        this.set(orientation, translation);
    }

    public void setIdentity() {
        this.quaternion.setToZero();
        this.translationVector.setToZero();
    }

    public void set(double qx, double qy, double qz, double qs, double x, double y, double z) {
        this.quaternion.set(qx, qy, qz, qs);
        this.translationVector.set(x, y, z);
    }

    public void setUnsafe(double qx, double qy, double qz, double qs, double x, double y, double z) {
        this.quaternion.setUnsafe(qx, qy, qz, qs);
        this.translationVector.set(x, y, z);
    }

    @Override
    public void set(QuaternionBasedTransform other) {
        this.set((RigidBodyTransformReadOnly)other);
    }

    @Override
    public void set(DMatrix matrix) {
        this.quaternion.set(matrix);
        this.translationVector.set(4, matrix);
    }

    @Override
    public void set(double[] array) {
        this.quaternion.set(array);
        this.translationVector.set(4, array);
    }

    public void interpolate(QuaternionBasedTransform other, double alpha) {
        this.interpolate(this, other, alpha);
    }

    public void interpolate(QuaternionBasedTransform firstTransform, QuaternionBasedTransform secondTransform, double alpha) {
        this.quaternion.interpolate(firstTransform.getRotation(), secondTransform.getRotation(), alpha);
        this.translationVector.interpolate(firstTransform.getTranslation(), secondTransform.getTranslation(), alpha);
    }

    public void get(DMatrix matrixToPack) {
        this.quaternion.get(matrixToPack);
        this.translationVector.get(4, matrixToPack);
    }

    public void get(int startRow, int column, DMatrix matrixToPack) {
        this.quaternion.get(startRow, column, matrixToPack);
        this.translationVector.get(startRow + 4, column, matrixToPack);
    }

    public void get(double[] transformArrayToPack) {
        this.quaternion.get(transformArrayToPack);
        this.translationVector.get(4, transformArrayToPack);
    }

    @Override
    public QuaternionBasics getRotation() {
        return this.quaternion;
    }

    @Override
    public Vector3DBasics getTranslation() {
        return this.translationVector;
    }

    @Override
    public boolean epsilonEquals(EuclidGeometry geometry, double epsilon) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof QuaternionBasedTransform)) {
            return false;
        }
        QuaternionBasedTransform other = (QuaternionBasedTransform)geometry;
        return this.quaternion.epsilonEquals(other.quaternion, epsilon) && this.translationVector.epsilonEquals(other.translationVector, epsilon);
    }

    public boolean equals(Object object) {
        if (object instanceof QuaternionBasedTransform) {
            return this.equals((EuclidGeometry)object);
        }
        return false;
    }

    @Override
    public boolean equals(EuclidGeometry geometry) {
        if (geometry == this) {
            return true;
        }
        if (geometry == null) {
            return false;
        }
        if (!(geometry instanceof QuaternionBasedTransform)) {
            return false;
        }
        QuaternionBasedTransform other = (QuaternionBasedTransform)geometry;
        return this.quaternion.equals(other.quaternion) && this.translationVector.equals(other.translationVector);
    }

    public String toString() {
        return this.toString(EuclidCoreIOTools.DEFAULT_FORMAT);
    }

    @Override
    public String toString(String format) {
        return EuclidCoreIOTools.getQuaternionBasedTransformString(format, this);
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)this.quaternion.hashCode(), this.translationVector.hashCode());
        return EuclidHashCodeTools.toIntHashCode(bits);
    }
}

