/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.tools;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class TupleTools {
    public static final double EPS_MAX_NORM = 1.0E-7;

    private TupleTools() {
    }

    public static double dot(double x, double y, Tuple2DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY();
    }

    public static double dot(double x, double y, double z, Tuple3DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY() + z * tuple.getZ();
    }

    public static double dot(double x, double y, double z, double s, Tuple4DReadOnly tuple) {
        return x * tuple.getX() + y * tuple.getY() + z * tuple.getZ() + s * tuple.getS();
    }

    public static double dot(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getX() + tuple1.getY() * tuple2.getY();
    }

    public static double dot(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        return tuple1.getX() * tuple2.getX() + tuple1.getY() * tuple2.getY() + tuple1.getZ() * tuple2.getZ();
    }

    public static double angle(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2) {
        double x1 = tuple1.getX();
        double y1 = tuple1.getY();
        double x2 = tuple2.getX();
        double y2 = tuple2.getY();
        return TupleTools.angle(x1, y1, x2, y2);
    }

    public static double angle(double x1, double y1, double x2, double y2) {
        double cosTheta = x1 * x2 + y1 * y2;
        double sinTheta = x1 * y2 - y1 * x2;
        return EuclidCoreTools.atan2(sinTheta, cosTheta);
    }

    public static double angle(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2) {
        double x1 = tuple1.getX();
        double y1 = tuple1.getY();
        double z1 = tuple1.getZ();
        double x2 = tuple2.getX();
        double y2 = tuple2.getY();
        double z2 = tuple2.getZ();
        return TupleTools.angle(x1, y1, z1, x2, y2, z2);
    }

    public static double angle(double x1, double y1, double z1, double x2, double y2, double z2) {
        double crossX = y1 * z2 - z1 * y2;
        double crossY = z1 * x2 - x1 * z2;
        double crossZ = x1 * y2 - y1 * x2;
        double cosTheta = x1 * x2 + y1 * y2 + z1 * z2;
        double sinTheta = EuclidCoreTools.norm(crossX, crossY, crossZ);
        return EuclidCoreTools.atan2(sinTheta, cosTheta);
    }

    public static boolean epsilonEquals(Tuple2DReadOnly tuple1, Tuple2DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon);
    }

    public static boolean epsilonEquals(Tuple3DReadOnly tuple1, Tuple3DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getZ(), tuple2.getZ(), epsilon);
    }

    public static boolean epsilonEquals(Tuple4DReadOnly tuple1, Tuple4DReadOnly tuple2, double epsilon) {
        if (!EuclidCoreTools.epsilonEquals(tuple1.getX(), tuple2.getX(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getY(), tuple2.getY(), epsilon)) {
            return false;
        }
        if (!EuclidCoreTools.epsilonEquals(tuple1.getZ(), tuple2.getZ(), epsilon)) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals(tuple1.getS(), tuple2.getS(), epsilon);
    }

    public static boolean isTupleZero(Tuple2DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), epsilon);
    }

    public static boolean isTupleZero(Tuple3DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), tuple.getZ(), epsilon);
    }

    public static boolean isTupleZero(Tuple4DReadOnly tuple, double epsilon) {
        return EuclidCoreTools.areAllZero(tuple.getX(), tuple.getY(), tuple.getZ(), tuple.getS(), epsilon);
    }
}

