/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.euclid.axisAngle.interfaces;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.Clearable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.rotationConversion.AxisAngleConversion;
import us.ihmc.euclid.tools.AxisAngleTools;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public interface AxisAngleBasics
extends AxisAngleReadOnly,
Orientation3DBasics,
Clearable {
    @Override
    public UnitVector3DBasics getAxis();

    public void setAngle(double var1);

    default public void setX(double x) {
        this.getAxis().setX(x);
    }

    default public void setY(double y) {
        this.getAxis().setY(y);
    }

    default public void setZ(double z) {
        this.getAxis().setZ(z);
    }

    @Override
    default public void setToZero() {
        this.getAxis().set(Axis3D.X);
        this.setAngle(0.0);
    }

    @Override
    default public void setToNaN() {
        this.getAxis().setToNaN();
        this.setAngle(Double.NaN);
    }

    @Override
    default public boolean containsNaN() {
        return AxisAngleReadOnly.super.containsNaN();
    }

    default public void absolute() {
        this.getAxis().absolute();
        this.setAngle(Math.abs(this.getAngle()));
    }

    default public void negate() {
        this.getAxis().negate();
        this.setAngle(-this.getAngle());
    }

    @Override
    default public void invert() {
        this.setAngle(-this.getAngle());
    }

    @Override
    default public void normalize() {
        this.getAxis().normalize();
    }

    default public void scaleAngle(double scale) {
        this.setAngle(scale * this.getAngle());
    }

    default public void set(double x, double y, double z, double angle) {
        this.getAxis().set(x, y, z);
        this.setAngle(angle);
    }

    @Override
    default public void set(Orientation3DReadOnly orientation3DReadOnly) {
        if (orientation3DReadOnly instanceof AxisAngleReadOnly) {
            this.set((AxisAngleReadOnly)orientation3DReadOnly);
        } else {
            orientation3DReadOnly.get(this);
        }
    }

    default public void set(Vector3DReadOnly axis, double angle) {
        this.getAxis().set(axis);
        this.setAngle(angle);
    }

    default public void set(AxisAngleReadOnly other) {
        this.getAxis().set(other.getAxis());
        this.setAngle(other.getAngle());
    }

    default public void setAndNegate(AxisAngleReadOnly other) {
        this.set(other);
        this.negate();
    }

    default public void set(double[] axisAngleArray) {
        this.set(0, axisAngleArray);
    }

    default public void set(int startIndex, double[] axisAngleArray) {
        this.setX(axisAngleArray[startIndex++]);
        this.setY(axisAngleArray[startIndex++]);
        this.setZ(axisAngleArray[startIndex++]);
        this.setAngle(axisAngleArray[startIndex]);
    }

    default public void set(float[] axisAngleArray) {
        this.set(0, axisAngleArray);
    }

    default public void set(int startIndex, float[] axisAngleArray) {
        this.setX(axisAngleArray[startIndex++]);
        this.setY(axisAngleArray[startIndex++]);
        this.setZ(axisAngleArray[startIndex++]);
        this.setAngle(axisAngleArray[startIndex]);
    }

    @Override
    default public void setAxisAngle(double x, double y, double z, double angle) {
        this.set(x, y, z, angle);
    }

    @Override
    default public void setQuaternion(double x, double y, double z, double s) {
        AxisAngleConversion.convertQuaternionToAxisAngle(x, y, z, s, this);
    }

    @Override
    default public void setRotationVector(double x, double y, double z) {
        AxisAngleConversion.convertRotationVectorToAxisAngle(x, y, z, this);
    }

    @Override
    default public void setYawPitchRoll(double yaw, double pitch, double roll) {
        AxisAngleConversion.convertYawPitchRollToAxisAngle(yaw, pitch, roll, this);
    }

    @Override
    default public void setRotationMatrix(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        AxisAngleConversion.convertMatrixToAxisAngle(m00, m01, m02, m10, m11, m12, m20, m21, m22, this);
    }

    @Override
    default public void setToYawOrientation(double yaw) {
        this.getAxis().set(Axis3D.Z);
        this.setAngle(yaw);
    }

    @Override
    default public void setToPitchOrientation(double pitch) {
        this.getAxis().set(Axis3D.Y);
        this.setAngle(pitch);
    }

    @Override
    default public void setToRollOrientation(double roll) {
        this.getAxis().set(Axis3D.X);
        this.setAngle(roll);
    }

    default public void setElement(int index, double value) {
        switch (index) {
            case 0: {
                this.setX(value);
                break;
            }
            case 1: {
                this.setY(value);
                break;
            }
            case 2: {
                this.setZ(value);
                break;
            }
            case 3: {
                this.setAngle(value);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
        }
    }

    default public void multiply(AxisAngleReadOnly other) {
        AxisAngleTools.multiply(this, other, this);
    }

    @Override
    default public void append(Orientation3DReadOnly other) {
        AxisAngleTools.multiply(this, false, other, false, this);
    }

    default public void multiply(AxisAngleReadOnly aa1, AxisAngleReadOnly aa2) {
        AxisAngleTools.multiply(aa1, aa2, this);
    }

    default public void multiplyInvertOther(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertRight(this, other, this);
    }

    @Override
    default public void appendInvertOther(Orientation3DReadOnly orientation) {
        AxisAngleTools.multiply(this, false, orientation, true, this);
    }

    default public void multiplyInvertThis(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertLeft(this, other, this);
    }

    default public void multiplyInvertBoth(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertBoth(this, other, this);
    }

    @Override
    default public void appendYawRotation(double yaw) {
        AxisAngleTools.appendYawRotation(this, yaw, this);
    }

    @Override
    default public void appendPitchRotation(double pitch) {
        AxisAngleTools.appendPitchRotation(this, pitch, this);
    }

    @Override
    default public void appendRollRotation(double roll) {
        AxisAngleTools.appendRollRotation(this, roll, this);
    }

    default public void preMultiply(AxisAngleReadOnly other) {
        AxisAngleTools.multiply(other, this, this);
    }

    @Override
    default public void prepend(Orientation3DReadOnly orientation) {
        AxisAngleTools.multiply(orientation, false, this, false, this);
    }

    default public void preMultiplyInvertOther(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertLeft(other, this, this);
    }

    @Override
    default public void prependInvertOther(Orientation3DReadOnly orientation) {
        AxisAngleTools.multiply(orientation, true, this, false, this);
    }

    default public void preMultiplyInvertThis(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertRight(other, this, this);
    }

    default public void preMultiplyInvertBoth(AxisAngleReadOnly other) {
        AxisAngleTools.multiplyInvertBoth(other, this, this);
    }

    @Override
    default public void prependYawRotation(double yaw) {
        AxisAngleTools.prependYawRotation(yaw, this, this);
    }

    @Override
    default public void prependPitchRotation(double pitch) {
        AxisAngleTools.prependPitchRotation(pitch, this, this);
    }

    @Override
    default public void prependRollRotation(double roll) {
        AxisAngleTools.prependRollRotation(roll, this, this);
    }
}

