/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.ParallelDataDataLocation;
import software.amazon.awssdk.services.translate.model.ParallelDataProperties;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParallelDataResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, GetParallelDataResponse> {
    private static final SdkField<ParallelDataProperties> PARALLEL_DATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelDataProperties").getter(GetParallelDataResponse.getter(GetParallelDataResponse::parallelDataProperties)).setter(GetParallelDataResponse.setter(Builder::parallelDataProperties)).constructor(ParallelDataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataProperties").build()}).build();
    private static final SdkField<ParallelDataDataLocation> DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLocation").getter(GetParallelDataResponse.getter(GetParallelDataResponse::dataLocation)).setter(GetParallelDataResponse.setter(Builder::dataLocation)).constructor(ParallelDataDataLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLocation").build()}).build();
    private static final SdkField<ParallelDataDataLocation> AUXILIARY_DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuxiliaryDataLocation").getter(GetParallelDataResponse.getter(GetParallelDataResponse::auxiliaryDataLocation)).setter(GetParallelDataResponse.setter(Builder::auxiliaryDataLocation)).constructor(ParallelDataDataLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuxiliaryDataLocation").build()}).build();
    private static final SdkField<ParallelDataDataLocation> LATEST_UPDATE_ATTEMPT_AUXILIARY_DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestUpdateAttemptAuxiliaryDataLocation").getter(GetParallelDataResponse.getter(GetParallelDataResponse::latestUpdateAttemptAuxiliaryDataLocation)).setter(GetParallelDataResponse.setter(Builder::latestUpdateAttemptAuxiliaryDataLocation)).constructor(ParallelDataDataLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptAuxiliaryDataLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARALLEL_DATA_PROPERTIES_FIELD, DATA_LOCATION_FIELD, AUXILIARY_DATA_LOCATION_FIELD, LATEST_UPDATE_ATTEMPT_AUXILIARY_DATA_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetParallelDataResponse.memberNameToFieldInitializer();
    private final ParallelDataProperties parallelDataProperties;
    private final ParallelDataDataLocation dataLocation;
    private final ParallelDataDataLocation auxiliaryDataLocation;
    private final ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation;

    private GetParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.parallelDataProperties = builder.parallelDataProperties;
        this.dataLocation = builder.dataLocation;
        this.auxiliaryDataLocation = builder.auxiliaryDataLocation;
        this.latestUpdateAttemptAuxiliaryDataLocation = builder.latestUpdateAttemptAuxiliaryDataLocation;
    }

    public final ParallelDataProperties parallelDataProperties() {
        return this.parallelDataProperties;
    }

    public final ParallelDataDataLocation dataLocation() {
        return this.dataLocation;
    }

    public final ParallelDataDataLocation auxiliaryDataLocation() {
        return this.auxiliaryDataLocation;
    }

    public final ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation() {
        return this.latestUpdateAttemptAuxiliaryDataLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelDataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.auxiliaryDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUpdateAttemptAuxiliaryDataLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParallelDataResponse)) {
            return false;
        }
        GetParallelDataResponse other = (GetParallelDataResponse)((Object)obj);
        return Objects.equals(this.parallelDataProperties(), other.parallelDataProperties()) && Objects.equals(this.dataLocation(), other.dataLocation()) && Objects.equals(this.auxiliaryDataLocation(), other.auxiliaryDataLocation()) && Objects.equals(this.latestUpdateAttemptAuxiliaryDataLocation(), other.latestUpdateAttemptAuxiliaryDataLocation());
    }

    public final String toString() {
        return ToString.builder((String)"GetParallelDataResponse").add("ParallelDataProperties", (Object)this.parallelDataProperties()).add("DataLocation", (Object)this.dataLocation()).add("AuxiliaryDataLocation", (Object)this.auxiliaryDataLocation()).add("LatestUpdateAttemptAuxiliaryDataLocation", (Object)this.latestUpdateAttemptAuxiliaryDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParallelDataProperties": {
                return Optional.ofNullable(clazz.cast(this.parallelDataProperties()));
            }
            case "DataLocation": {
                return Optional.ofNullable(clazz.cast(this.dataLocation()));
            }
            case "AuxiliaryDataLocation": {
                return Optional.ofNullable(clazz.cast(this.auxiliaryDataLocation()));
            }
            case "LatestUpdateAttemptAuxiliaryDataLocation": {
                return Optional.ofNullable(clazz.cast(this.latestUpdateAttemptAuxiliaryDataLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParallelDataProperties", PARALLEL_DATA_PROPERTIES_FIELD);
        map.put("DataLocation", DATA_LOCATION_FIELD);
        map.put("AuxiliaryDataLocation", AUXILIARY_DATA_LOCATION_FIELD);
        map.put("LatestUpdateAttemptAuxiliaryDataLocation", LATEST_UPDATE_ATTEMPT_AUXILIARY_DATA_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetParallelDataResponse, T> g) {
        return obj -> g.apply((GetParallelDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private ParallelDataProperties parallelDataProperties;
        private ParallelDataDataLocation dataLocation;
        private ParallelDataDataLocation auxiliaryDataLocation;
        private ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParallelDataResponse model) {
            super(model);
            this.parallelDataProperties(model.parallelDataProperties);
            this.dataLocation(model.dataLocation);
            this.auxiliaryDataLocation(model.auxiliaryDataLocation);
            this.latestUpdateAttemptAuxiliaryDataLocation(model.latestUpdateAttemptAuxiliaryDataLocation);
        }

        public final ParallelDataProperties.Builder getParallelDataProperties() {
            return this.parallelDataProperties != null ? this.parallelDataProperties.toBuilder() : null;
        }

        public final void setParallelDataProperties(ParallelDataProperties.BuilderImpl parallelDataProperties) {
            this.parallelDataProperties = parallelDataProperties != null ? parallelDataProperties.build() : null;
        }

        @Override
        public final Builder parallelDataProperties(ParallelDataProperties parallelDataProperties) {
            this.parallelDataProperties = parallelDataProperties;
            return this;
        }

        public final ParallelDataDataLocation.Builder getDataLocation() {
            return this.dataLocation != null ? this.dataLocation.toBuilder() : null;
        }

        public final void setDataLocation(ParallelDataDataLocation.BuilderImpl dataLocation) {
            this.dataLocation = dataLocation != null ? dataLocation.build() : null;
        }

        @Override
        public final Builder dataLocation(ParallelDataDataLocation dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final ParallelDataDataLocation.Builder getAuxiliaryDataLocation() {
            return this.auxiliaryDataLocation != null ? this.auxiliaryDataLocation.toBuilder() : null;
        }

        public final void setAuxiliaryDataLocation(ParallelDataDataLocation.BuilderImpl auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation != null ? auxiliaryDataLocation.build() : null;
        }

        @Override
        public final Builder auxiliaryDataLocation(ParallelDataDataLocation auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation;
            return this;
        }

        public final ParallelDataDataLocation.Builder getLatestUpdateAttemptAuxiliaryDataLocation() {
            return this.latestUpdateAttemptAuxiliaryDataLocation != null ? this.latestUpdateAttemptAuxiliaryDataLocation.toBuilder() : null;
        }

        public final void setLatestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation.BuilderImpl latestUpdateAttemptAuxiliaryDataLocation) {
            this.latestUpdateAttemptAuxiliaryDataLocation = latestUpdateAttemptAuxiliaryDataLocation != null ? latestUpdateAttemptAuxiliaryDataLocation.build() : null;
        }

        @Override
        public final Builder latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation latestUpdateAttemptAuxiliaryDataLocation) {
            this.latestUpdateAttemptAuxiliaryDataLocation = latestUpdateAttemptAuxiliaryDataLocation;
            return this;
        }

        @Override
        public GetParallelDataResponse build() {
            return new GetParallelDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParallelDataResponse> {
        public Builder parallelDataProperties(ParallelDataProperties var1);

        default public Builder parallelDataProperties(Consumer<ParallelDataProperties.Builder> parallelDataProperties) {
            return this.parallelDataProperties((ParallelDataProperties)((ParallelDataProperties.Builder)ParallelDataProperties.builder().applyMutation(parallelDataProperties)).build());
        }

        public Builder dataLocation(ParallelDataDataLocation var1);

        default public Builder dataLocation(Consumer<ParallelDataDataLocation.Builder> dataLocation) {
            return this.dataLocation((ParallelDataDataLocation)((ParallelDataDataLocation.Builder)ParallelDataDataLocation.builder().applyMutation(dataLocation)).build());
        }

        public Builder auxiliaryDataLocation(ParallelDataDataLocation var1);

        default public Builder auxiliaryDataLocation(Consumer<ParallelDataDataLocation.Builder> auxiliaryDataLocation) {
            return this.auxiliaryDataLocation((ParallelDataDataLocation)((ParallelDataDataLocation.Builder)ParallelDataDataLocation.builder().applyMutation(auxiliaryDataLocation)).build());
        }

        public Builder latestUpdateAttemptAuxiliaryDataLocation(ParallelDataDataLocation var1);

        default public Builder latestUpdateAttemptAuxiliaryDataLocation(Consumer<ParallelDataDataLocation.Builder> latestUpdateAttemptAuxiliaryDataLocation) {
            return this.latestUpdateAttemptAuxiliaryDataLocation((ParallelDataDataLocation)((ParallelDataDataLocation.Builder)ParallelDataDataLocation.builder().applyMutation(latestUpdateAttemptAuxiliaryDataLocation)).build());
        }
    }
}

