/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTerminologyResponse extends TranslateResponse implements
        ToCopyableBuilder<ImportTerminologyResponse.Builder, ImportTerminologyResponse> {
    private static final SdkField<TerminologyProperties> TERMINOLOGY_PROPERTIES_FIELD = SdkField
            .<TerminologyProperties> builder(MarshallingType.SDK_POJO).memberName("TerminologyProperties")
            .getter(getter(ImportTerminologyResponse::terminologyProperties)).setter(setter(Builder::terminologyProperties))
            .constructor(TerminologyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyProperties").build())
            .build();

    private static final SdkField<TerminologyDataLocation> AUXILIARY_DATA_LOCATION_FIELD = SdkField
            .<TerminologyDataLocation> builder(MarshallingType.SDK_POJO).memberName("AuxiliaryDataLocation")
            .getter(getter(ImportTerminologyResponse::auxiliaryDataLocation)).setter(setter(Builder::auxiliaryDataLocation))
            .constructor(TerminologyDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuxiliaryDataLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINOLOGY_PROPERTIES_FIELD,
            AUXILIARY_DATA_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TerminologyProperties terminologyProperties;

    private final TerminologyDataLocation auxiliaryDataLocation;

    private ImportTerminologyResponse(BuilderImpl builder) {
        super(builder);
        this.terminologyProperties = builder.terminologyProperties;
        this.auxiliaryDataLocation = builder.auxiliaryDataLocation;
    }

    /**
     * <p>
     * The properties of the custom terminology being imported.
     * </p>
     * 
     * @return The properties of the custom terminology being imported.
     */
    public final TerminologyProperties terminologyProperties() {
        return terminologyProperties;
    }

    /**
     * <p>
     * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This
     * file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a
     * presigned URL to that has a 30 minute expiration.
     * </p>
     * 
     * @return The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
     *         file. This file was created when Amazon Translate attempted to create a terminology resource. The
     *         location is returned as a presigned URL to that has a 30 minute expiration.
     */
    public final TerminologyDataLocation auxiliaryDataLocation() {
        return auxiliaryDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(terminologyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(auxiliaryDataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTerminologyResponse)) {
            return false;
        }
        ImportTerminologyResponse other = (ImportTerminologyResponse) obj;
        return Objects.equals(terminologyProperties(), other.terminologyProperties())
                && Objects.equals(auxiliaryDataLocation(), other.auxiliaryDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTerminologyResponse").add("TerminologyProperties", terminologyProperties())
                .add("AuxiliaryDataLocation", auxiliaryDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminologyProperties":
            return Optional.ofNullable(clazz.cast(terminologyProperties()));
        case "AuxiliaryDataLocation":
            return Optional.ofNullable(clazz.cast(auxiliaryDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TerminologyProperties", TERMINOLOGY_PROPERTIES_FIELD);
        map.put("AuxiliaryDataLocation", AUXILIARY_DATA_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportTerminologyResponse, T> g) {
        return obj -> g.apply((ImportTerminologyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, ImportTerminologyResponse> {
        /**
         * <p>
         * The properties of the custom terminology being imported.
         * </p>
         * 
         * @param terminologyProperties
         *        The properties of the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyProperties(TerminologyProperties terminologyProperties);

        /**
         * <p>
         * The properties of the custom terminology being imported.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerminologyProperties.Builder} avoiding
         * the need to create one manually via {@link TerminologyProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TerminologyProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #terminologyProperties(TerminologyProperties)}.
         * 
         * @param terminologyProperties
         *        a consumer that will call methods on {@link TerminologyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyProperties(TerminologyProperties)
         */
        default Builder terminologyProperties(Consumer<TerminologyProperties.Builder> terminologyProperties) {
            return terminologyProperties(TerminologyProperties.builder().applyMutation(terminologyProperties).build());
        }

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a terminology resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * 
         * @param auxiliaryDataLocation
         *        The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
         *        file. This file was created when Amazon Translate attempted to create a terminology resource. The
         *        location is returned as a presigned URL to that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryDataLocation(TerminologyDataLocation auxiliaryDataLocation);

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a terminology resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerminologyDataLocation.Builder} avoiding
         * the need to create one manually via {@link TerminologyDataLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TerminologyDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #auxiliaryDataLocation(TerminologyDataLocation)}.
         * 
         * @param auxiliaryDataLocation
         *        a consumer that will call methods on {@link TerminologyDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auxiliaryDataLocation(TerminologyDataLocation)
         */
        default Builder auxiliaryDataLocation(Consumer<TerminologyDataLocation.Builder> auxiliaryDataLocation) {
            return auxiliaryDataLocation(TerminologyDataLocation.builder().applyMutation(auxiliaryDataLocation).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private TerminologyProperties terminologyProperties;

        private TerminologyDataLocation auxiliaryDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTerminologyResponse model) {
            super(model);
            terminologyProperties(model.terminologyProperties);
            auxiliaryDataLocation(model.auxiliaryDataLocation);
        }

        public final TerminologyProperties.Builder getTerminologyProperties() {
            return terminologyProperties != null ? terminologyProperties.toBuilder() : null;
        }

        public final void setTerminologyProperties(TerminologyProperties.BuilderImpl terminologyProperties) {
            this.terminologyProperties = terminologyProperties != null ? terminologyProperties.build() : null;
        }

        @Override
        public final Builder terminologyProperties(TerminologyProperties terminologyProperties) {
            this.terminologyProperties = terminologyProperties;
            return this;
        }

        public final TerminologyDataLocation.Builder getAuxiliaryDataLocation() {
            return auxiliaryDataLocation != null ? auxiliaryDataLocation.toBuilder() : null;
        }

        public final void setAuxiliaryDataLocation(TerminologyDataLocation.BuilderImpl auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation != null ? auxiliaryDataLocation.build() : null;
        }

        @Override
        public final Builder auxiliaryDataLocation(TerminologyDataLocation auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation;
            return this;
        }

        @Override
        public ImportTerminologyResponse build() {
            return new ImportTerminologyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
