/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.polly;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.polly.model.DeleteLexiconRequest;
import software.amazon.awssdk.services.polly.model.DeleteLexiconResponse;
import software.amazon.awssdk.services.polly.model.DescribeVoicesRequest;
import software.amazon.awssdk.services.polly.model.DescribeVoicesResponse;
import software.amazon.awssdk.services.polly.model.EngineNotSupportedException;
import software.amazon.awssdk.services.polly.model.GetLexiconRequest;
import software.amazon.awssdk.services.polly.model.GetLexiconResponse;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.InvalidLexiconException;
import software.amazon.awssdk.services.polly.model.InvalidNextTokenException;
import software.amazon.awssdk.services.polly.model.InvalidS3BucketException;
import software.amazon.awssdk.services.polly.model.InvalidS3KeyException;
import software.amazon.awssdk.services.polly.model.InvalidSampleRateException;
import software.amazon.awssdk.services.polly.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.polly.model.InvalidSsmlException;
import software.amazon.awssdk.services.polly.model.InvalidTaskIdException;
import software.amazon.awssdk.services.polly.model.LanguageNotSupportedException;
import software.amazon.awssdk.services.polly.model.LexiconNotFoundException;
import software.amazon.awssdk.services.polly.model.LexiconSizeExceededException;
import software.amazon.awssdk.services.polly.model.ListLexiconsRequest;
import software.amazon.awssdk.services.polly.model.ListLexiconsResponse;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;
import software.amazon.awssdk.services.polly.model.MarksNotSupportedForFormatException;
import software.amazon.awssdk.services.polly.model.MaxLexemeLengthExceededException;
import software.amazon.awssdk.services.polly.model.MaxLexiconsNumberExceededException;
import software.amazon.awssdk.services.polly.model.PollyException;
import software.amazon.awssdk.services.polly.model.PutLexiconRequest;
import software.amazon.awssdk.services.polly.model.PutLexiconResponse;
import software.amazon.awssdk.services.polly.model.ServiceFailureException;
import software.amazon.awssdk.services.polly.model.SsmlMarksNotSupportedForTextTypeException;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest;
import software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskResponse;
import software.amazon.awssdk.services.polly.model.SynthesisTaskNotFoundException;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest;
import software.amazon.awssdk.services.polly.model.SynthesizeSpeechResponse;
import software.amazon.awssdk.services.polly.model.TextLengthExceededException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsAlphabetException;
import software.amazon.awssdk.services.polly.model.UnsupportedPlsLanguageException;
import software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable;

/**
 * Service client for accessing Amazon Polly. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Polly is a web service that makes it easy to synthesize speech from text.
 * </p>
 * <p>
 * The Amazon Polly service provides API operations for synthesizing high-quality speech from plain text and Speech
 * Synthesis Markup Language (SSML), along with managing pronunciations lexicons that enable you to get the best results
 * for your application domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PollyClient extends AwsClient {
    String SERVICE_NAME = "polly";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "polly";

    /**
     * <p>
     * Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region. A lexicon which has been
     * deleted is not available for speech synthesis, nor is it possible to retrieve it using either the
     * <code>GetLexicon</code> or <code>ListLexicon</code> APIs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     *
     * @param deleteLexiconRequest
     * @return Result of the DeleteLexicon operation returned by the service.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.DeleteLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLexiconResponse deleteLexicon(DeleteLexiconRequest deleteLexiconRequest) throws LexiconNotFoundException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region. A lexicon which has been
     * deleted is not available for speech synthesis, nor is it possible to retrieve it using either the
     * <code>GetLexicon</code> or <code>ListLexicon</code> APIs.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLexiconRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLexiconRequest#builder()}
     * </p>
     *
     * @param deleteLexiconRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.DeleteLexiconRequest.Builder} to create a request.
     * @return Result of the DeleteLexicon operation returned by the service.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.DeleteLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DeleteLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLexiconResponse deleteLexicon(Consumer<DeleteLexiconRequest.Builder> deleteLexiconRequest)
            throws LexiconNotFoundException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return deleteLexicon(DeleteLexiconRequest.builder().applyMutation(deleteLexiconRequest).build());
    }

    /**
     * <p>
     * Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a
     * specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice
     * name.
     * </p>
     * <p>
     * When synthesizing speech ( <code>SynthesizeSpeech</code> ), you provide the voice ID for the voice you want from
     * the list of voices returned by <code>DescribeVoices</code>.
     * </p>
     * <p>
     * For example, you want your news reader application to read news in a specific language, but giving a user the
     * option to choose the voice. Using the <code>DescribeVoices</code> operation you can provide the user with a list
     * of available voices to select from.
     * </p>
     * <p>
     * You can optionally specify a language code to filter the available voices. For example, if you specify
     * <code>en-US</code>, the operation returns a list of all available US English voices.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>polly:DescribeVoices</code> action.
     * </p>
     *
     * @param describeVoicesRequest
     * @return Result of the DescribeVoices operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.DescribeVoices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeVoicesResponse describeVoices(DescribeVoicesRequest describeVoicesRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a
     * specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice
     * name.
     * </p>
     * <p>
     * When synthesizing speech ( <code>SynthesizeSpeech</code> ), you provide the voice ID for the voice you want from
     * the list of voices returned by <code>DescribeVoices</code>.
     * </p>
     * <p>
     * For example, you want your news reader application to read news in a specific language, but giving a user the
     * option to choose the voice. Using the <code>DescribeVoices</code> operation you can provide the user with a list
     * of available voices to select from.
     * </p>
     * <p>
     * You can optionally specify a language code to filter the available voices. For example, if you specify
     * <code>en-US</code>, the operation returns a list of all available US English voices.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>polly:DescribeVoices</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVoicesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeVoicesRequest#builder()}
     * </p>
     *
     * @param describeVoicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.DescribeVoicesRequest.Builder} to create a request.
     * @return Result of the DescribeVoices operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.DescribeVoices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeVoicesResponse describeVoices(Consumer<DescribeVoicesRequest.Builder> describeVoicesRequest)
            throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return describeVoices(DescribeVoicesRequest.builder().applyMutation(describeVoicesRequest).build());
    }

    /**
     * <p>
     * Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a
     * specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice
     * name.
     * </p>
     * <p>
     * When synthesizing speech ( <code>SynthesizeSpeech</code> ), you provide the voice ID for the voice you want from
     * the list of voices returned by <code>DescribeVoices</code>.
     * </p>
     * <p>
     * For example, you want your news reader application to read news in a specific language, but giving a user the
     * option to choose the voice. Using the <code>DescribeVoices</code> operation you can provide the user with a list
     * of available voices to select from.
     * </p>
     * <p>
     * You can optionally specify a language code to filter the available voices. For example, if you specify
     * <code>en-US</code>, the operation returns a list of all available US English voices.
     * </p>
     * <p>
     * This operation requires permissions to perform the <code>polly:DescribeVoices</code> action.
     * </p>
     *
     * @return Result of the DescribeVoices operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.DescribeVoices
     * @see #describeVoices(DescribeVoicesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/DescribeVoices" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeVoicesResponse describeVoices() throws InvalidNextTokenException, ServiceFailureException,
            AwsServiceException, SdkClientException, PollyException {
        return describeVoices(DescribeVoicesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the content of the specified pronunciation lexicon stored in an Amazon Web Services Region. For more
     * information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     *
     * @param getLexiconRequest
     * @return Result of the GetLexicon operation returned by the service.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.GetLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLexiconResponse getLexicon(GetLexiconRequest getLexiconRequest) throws LexiconNotFoundException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the content of the specified pronunciation lexicon stored in an Amazon Web Services Region. For more
     * information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLexiconRequest.Builder} avoiding the need to
     * create one manually via {@link GetLexiconRequest#builder()}
     * </p>
     *
     * @param getLexiconRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.GetLexiconRequest.Builder} to create a request.
     * @return Result of the GetLexicon operation returned by the service.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.GetLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLexiconResponse getLexicon(Consumer<GetLexiconRequest.Builder> getLexiconRequest) throws LexiconNotFoundException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return getLexicon(GetLexiconRequest.builder().applyMutation(getLexiconRequest).build());
    }

    /**
     * <p>
     * Retrieves a specific SpeechSynthesisTask object based on its TaskID. This object contains information about the
     * given speech synthesis task, including the status of the task, and a link to the S3 bucket containing the output
     * of the task.
     * </p>
     *
     * @param getSpeechSynthesisTaskRequest
     * @return Result of the GetSpeechSynthesisTask operation returned by the service.
     * @throws InvalidTaskIdException
     *         The provided Task ID is not valid. Please provide a valid Task ID and try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SynthesisTaskNotFoundException
     *         The Speech Synthesis task with requested Task ID cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.GetSpeechSynthesisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetSpeechSynthesisTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSpeechSynthesisTaskResponse getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest getSpeechSynthesisTaskRequest)
            throws InvalidTaskIdException, ServiceFailureException, SynthesisTaskNotFoundException, AwsServiceException,
            SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specific SpeechSynthesisTask object based on its TaskID. This object contains information about the
     * given speech synthesis task, including the status of the task, and a link to the S3 bucket containing the output
     * of the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSpeechSynthesisTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetSpeechSynthesisTaskRequest#builder()}
     * </p>
     *
     * @param getSpeechSynthesisTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.GetSpeechSynthesisTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetSpeechSynthesisTask operation returned by the service.
     * @throws InvalidTaskIdException
     *         The provided Task ID is not valid. Please provide a valid Task ID and try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SynthesisTaskNotFoundException
     *         The Speech Synthesis task with requested Task ID cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.GetSpeechSynthesisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/GetSpeechSynthesisTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSpeechSynthesisTaskResponse getSpeechSynthesisTask(
            Consumer<GetSpeechSynthesisTaskRequest.Builder> getSpeechSynthesisTaskRequest) throws InvalidTaskIdException,
            ServiceFailureException, SynthesisTaskNotFoundException, AwsServiceException, SdkClientException, PollyException {
        return getSpeechSynthesisTask(GetSpeechSynthesisTaskRequest.builder().applyMutation(getSpeechSynthesisTaskRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.
     * </p>
     *
     * @param listLexiconsRequest
     * @return Result of the ListLexicons operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListLexicons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexiconsResponse listLexicons(ListLexiconsRequest listLexiconsRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLexiconsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLexiconsRequest#builder()}
     * </p>
     *
     * @param listLexiconsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.ListLexiconsRequest.Builder} to create a request.
     * @return Result of the ListLexicons operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListLexicons
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexiconsResponse listLexicons(Consumer<ListLexiconsRequest.Builder> listLexiconsRequest)
            throws InvalidNextTokenException, ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return listLexicons(ListLexiconsRequest.builder().applyMutation(listLexiconsRequest).build());
    }

    /**
     * <p>
     * Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing Lexicons</a>.
     * </p>
     *
     * @return Result of the ListLexicons operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListLexicons
     * @see #listLexicons(ListLexiconsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListLexicons" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLexiconsResponse listLexicons() throws InvalidNextTokenException, ServiceFailureException, AwsServiceException,
            SdkClientException, PollyException {
        return listLexicons(ListLexiconsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of SpeechSynthesisTask objects ordered by their creation date. This operation can filter the tasks
     * by their status, for example, allowing users to list only tasks that are completed.
     * </p>
     *
     * @param listSpeechSynthesisTasksRequest
     * @return Result of the ListSpeechSynthesisTasks operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks(
            ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of SpeechSynthesisTask objects ordered by their creation date. This operation can filter the tasks
     * by their status, for example, allowing users to list only tasks that are completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeechSynthesisTasksRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeechSynthesisTasksRequest#builder()}
     * </p>
     *
     * @param listSpeechSynthesisTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListSpeechSynthesisTasks operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks(
            Consumer<ListSpeechSynthesisTasksRequest.Builder> listSpeechSynthesisTasksRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest.builder().applyMutation(listSpeechSynthesisTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of SpeechSynthesisTask objects ordered by their creation date. This operation can filter the tasks
     * by their status, for example, allowing users to list only tasks that are completed.
     * </p>
     *
     * @return Result of the ListSpeechSynthesisTasks operation returned by the service.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see #listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksResponse listSpeechSynthesisTasks() throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return listSpeechSynthesisTasks(ListSpeechSynthesisTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client
     *             .listSpeechSynthesisTasksPaginator(request);
     *     for (software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see #listSpeechSynthesisTasksPaginator(ListSpeechSynthesisTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksIterable listSpeechSynthesisTasksPaginator() throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return listSpeechSynthesisTasksPaginator(ListSpeechSynthesisTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client
     *             .listSpeechSynthesisTasksPaginator(request);
     *     for (software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSpeechSynthesisTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksIterable listSpeechSynthesisTasksPaginator(
            ListSpeechSynthesisTasksRequest listSpeechSynthesisTasksRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return new ListSpeechSynthesisTasksIterable(this, listSpeechSynthesisTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client
     *             .listSpeechSynthesisTasksPaginator(request);
     *     for (software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.polly.paginators.ListSpeechSynthesisTasksIterable responses = client.listSpeechSynthesisTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSpeechSynthesisTasks(software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSpeechSynthesisTasksRequest.Builder} avoiding
     * the need to create one manually via {@link ListSpeechSynthesisTasksRequest#builder()}
     * </p>
     *
     * @param listSpeechSynthesisTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The NextToken is invalid. Verify that it's spelled correctly, and then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.ListSpeechSynthesisTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/ListSpeechSynthesisTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSpeechSynthesisTasksIterable listSpeechSynthesisTasksPaginator(
            Consumer<ListSpeechSynthesisTasksRequest.Builder> listSpeechSynthesisTasksRequest) throws InvalidNextTokenException,
            ServiceFailureException, AwsServiceException, SdkClientException, PollyException {
        return listSpeechSynthesisTasksPaginator(ListSpeechSynthesisTasksRequest.builder()
                .applyMutation(listSpeechSynthesisTasksRequest).build());
    }

    /**
     * <p>
     * Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists
     * in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it
     * might take some time before the lexicon is available to the SynthesizeSpeech operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     *
     * @param putLexiconRequest
     * @return Result of the PutLexicon operation returned by the service.
     * @throws InvalidLexiconException
     *         Amazon Polly can't find the specified lexicon. Verify that the lexicon's name is spelled correctly, and
     *         then try again.
     * @throws UnsupportedPlsAlphabetException
     *         The alphabet specified by the lexicon is not a supported alphabet. Valid values are <code>x-sampa</code>
     *         and <code>ipa</code>.
     * @throws UnsupportedPlsLanguageException
     *         The language specified in the lexicon is unsupported. For a list of supported languages, see <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html">Lexicon Attributes</a>.
     * @throws LexiconSizeExceededException
     *         The maximum size of the specified lexicon would be exceeded by this operation.
     * @throws MaxLexemeLengthExceededException
     *         The maximum size of the lexeme would be exceeded by this operation.
     * @throws MaxLexiconsNumberExceededException
     *         The maximum number of lexicons would be exceeded by this operation.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.PutLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLexiconResponse putLexicon(PutLexiconRequest putLexiconRequest) throws InvalidLexiconException,
            UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException,
            MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists
     * in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it
     * might take some time before the lexicon is available to the SynthesizeSpeech operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html">Managing
     * Lexicons</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLexiconRequest.Builder} avoiding the need to
     * create one manually via {@link PutLexiconRequest#builder()}
     * </p>
     *
     * @param putLexiconRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.PutLexiconRequest.Builder} to create a request.
     * @return Result of the PutLexicon operation returned by the service.
     * @throws InvalidLexiconException
     *         Amazon Polly can't find the specified lexicon. Verify that the lexicon's name is spelled correctly, and
     *         then try again.
     * @throws UnsupportedPlsAlphabetException
     *         The alphabet specified by the lexicon is not a supported alphabet. Valid values are <code>x-sampa</code>
     *         and <code>ipa</code>.
     * @throws UnsupportedPlsLanguageException
     *         The language specified in the lexicon is unsupported. For a list of supported languages, see <a
     *         href="https://docs.aws.amazon.com/polly/latest/dg/API_LexiconAttributes.html">Lexicon Attributes</a>.
     * @throws LexiconSizeExceededException
     *         The maximum size of the specified lexicon would be exceeded by this operation.
     * @throws MaxLexemeLengthExceededException
     *         The maximum size of the lexeme would be exceeded by this operation.
     * @throws MaxLexiconsNumberExceededException
     *         The maximum number of lexicons would be exceeded by this operation.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.PutLexicon
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/PutLexicon" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLexiconResponse putLexicon(Consumer<PutLexiconRequest.Builder> putLexiconRequest) throws InvalidLexiconException,
            UnsupportedPlsAlphabetException, UnsupportedPlsLanguageException, LexiconSizeExceededException,
            MaxLexemeLengthExceededException, MaxLexiconsNumberExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, PollyException {
        return putLexicon(PutLexiconRequest.builder().applyMutation(putLexiconRequest).build());
    }

    /**
     * <p>
     * Allows the creation of an asynchronous synthesis task, by starting a new <code>SpeechSynthesisTask</code>. This
     * operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket
     * for the service to store the output of the synthesis task and two optional parameters (
     * <code>OutputS3KeyPrefix</code> and <code>SnsTopicArn</code>). Once the synthesis task is created, this operation
     * will return a <code>SpeechSynthesisTask</code> object, which will include an identifier of this task as well as
     * the current status. The <code>SpeechSynthesisTask</code> object is available for 72 hours after starting the
     * asynchronous synthesis task.
     * </p>
     *
     * @param startSpeechSynthesisTaskRequest
     * @return Result of the StartSpeechSynthesisTask operation returned by the service.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidS3BucketException
     *         The provided Amazon S3 bucket name is invalid. Please check your input with S3 bucket naming requirements
     *         and try again.
     * @throws InvalidS3KeyException
     *         The provided Amazon S3 key prefix is invalid. Please provide a valid S3 object key name.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSnsTopicArnException
     *         The provided SNS topic ARN is invalid. Please provide a valid SNS topic ARN and try again.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.StartSpeechSynthesisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/StartSpeechSynthesisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSpeechSynthesisTaskResponse startSpeechSynthesisTask(
            StartSpeechSynthesisTaskRequest startSpeechSynthesisTaskRequest) throws TextLengthExceededException,
            InvalidS3BucketException, InvalidS3KeyException, InvalidSampleRateException, InvalidSnsTopicArnException,
            InvalidSsmlException, EngineNotSupportedException, LexiconNotFoundException, ServiceFailureException,
            MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException,
            AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the creation of an asynchronous synthesis task, by starting a new <code>SpeechSynthesisTask</code>. This
     * operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket
     * for the service to store the output of the synthesis task and two optional parameters (
     * <code>OutputS3KeyPrefix</code> and <code>SnsTopicArn</code>). Once the synthesis task is created, this operation
     * will return a <code>SpeechSynthesisTask</code> object, which will include an identifier of this task as well as
     * the current status. The <code>SpeechSynthesisTask</code> object is available for 72 hours after starting the
     * asynchronous synthesis task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSpeechSynthesisTaskRequest.Builder} avoiding
     * the need to create one manually via {@link StartSpeechSynthesisTaskRequest#builder()}
     * </p>
     *
     * @param startSpeechSynthesisTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.StartSpeechSynthesisTaskRequest.Builder} to create a
     *        request.
     * @return Result of the StartSpeechSynthesisTask operation returned by the service.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidS3BucketException
     *         The provided Amazon S3 bucket name is invalid. Please check your input with S3 bucket naming requirements
     *         and try again.
     * @throws InvalidS3KeyException
     *         The provided Amazon S3 key prefix is invalid. Please provide a valid S3 object key name.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSnsTopicArnException
     *         The provided SNS topic ARN is invalid. Please provide a valid SNS topic ARN and try again.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.StartSpeechSynthesisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/StartSpeechSynthesisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSpeechSynthesisTaskResponse startSpeechSynthesisTask(
            Consumer<StartSpeechSynthesisTaskRequest.Builder> startSpeechSynthesisTaskRequest)
            throws TextLengthExceededException, InvalidS3BucketException, InvalidS3KeyException, InvalidSampleRateException,
            InvalidSnsTopicArnException, InvalidSsmlException, EngineNotSupportedException, LexiconNotFoundException,
            ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException,
            LanguageNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return startSpeechSynthesisTask(StartSpeechSynthesisTaskRequest.builder().applyMutation(startSpeechSynthesisTaskRequest)
                .build());
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     *
     * @param synthesizeSpeechRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        SynthesizeSpeechResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Stream containing the synthesized speech.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> ReturnT synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest,
            ResponseTransformer<SynthesizeSpeechResponse, ReturnT> responseTransformer) throws TextLengthExceededException,
            InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException,
            MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException,
            EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SynthesizeSpeechRequest.Builder} avoiding the need
     * to create one manually via {@link SynthesizeSpeechRequest#builder()}
     * </p>
     *
     * @param synthesizeSpeechRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest.Builder} to create a request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        SynthesizeSpeechResponse and an InputStream to the response content are provided as parameters to the
     *        callback. The callback may return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        Stream containing the synthesized speech.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> ReturnT synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest,
            ResponseTransformer<SynthesizeSpeechResponse, ReturnT> responseTransformer) throws TextLengthExceededException,
            InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException,
            MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException,
            EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest).build(),
                responseTransformer);
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     *
     * @param synthesizeSpeechRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Stream containing the synthesized speech.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #synthesizeSpeech(SynthesizeSpeechRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default SynthesizeSpeechResponse synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest, Path destinationPath)
            throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException,
            ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException,
            LanguageNotSupportedException, EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SynthesizeSpeechRequest.Builder} avoiding the need
     * to create one manually via {@link SynthesizeSpeechRequest#builder()}
     * </p>
     *
     * @param synthesizeSpeechRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        Stream containing the synthesized speech.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #synthesizeSpeech(SynthesizeSpeechRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default SynthesizeSpeechResponse synthesizeSpeech(Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest,
            Path destinationPath) throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException,
            LexiconNotFoundException, ServiceFailureException, MarksNotSupportedForFormatException,
            SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException, EngineNotSupportedException,
            AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     *
     * @param synthesizeSpeechRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Stream containing the synthesized speech.
     *         </p>
     *         '.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #getObject(synthesizeSpeech, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default ResponseInputStream<SynthesizeSpeechResponse> synthesizeSpeech(SynthesizeSpeechRequest synthesizeSpeechRequest)
            throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException,
            ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException,
            LanguageNotSupportedException, EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SynthesizeSpeechRequest.Builder} avoiding the need
     * to create one manually via {@link SynthesizeSpeechRequest#builder()}
     * </p>
     *
     * @param synthesizeSpeechRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest.Builder} to create a request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         Stream containing the synthesized speech.
     *         </p>
     *         '.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #getObject(synthesizeSpeech, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default ResponseInputStream<SynthesizeSpeechResponse> synthesizeSpeech(
            Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest) throws TextLengthExceededException,
            InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException,
            MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException,
            EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest).build());
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     *
     * @param synthesizeSpeechRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Stream containing the synthesized speech.
     *         </p>
     *         '.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #getObject(synthesizeSpeech, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default ResponseBytes<SynthesizeSpeechResponse> synthesizeSpeechAsBytes(SynthesizeSpeechRequest synthesizeSpeechRequest)
            throws TextLengthExceededException, InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException,
            ServiceFailureException, MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException,
            LanguageNotSupportedException, EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeech(synthesizeSpeechRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML.
     * Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by
     * English voices) unless phoneme mapping is used. For more information, see <a
     * href="https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html">How it Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SynthesizeSpeechRequest.Builder} avoiding the need
     * to create one manually via {@link SynthesizeSpeechRequest#builder()}
     * </p>
     *
     * @param synthesizeSpeechRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.polly.model.SynthesizeSpeechRequest.Builder} to create a request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         Stream containing the synthesized speech.
     *         </p>
     *         '.
     * @throws TextLengthExceededException
     *         The value of the "Text" parameter is longer than the accepted limits. For the
     *         <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of
     *         which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the
     *         maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not
     *         counted as billed characters.
     * @throws InvalidSampleRateException
     *         The specified sample rate is not valid.
     * @throws InvalidSsmlException
     *         The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try
     *         again.
     * @throws LexiconNotFoundException
     *         Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its
     *         name is misspelled or specifying a lexicon that is in a different region.</p>
     *         <p>
     *         Verify that the lexicon exists, is in the region (see <a>ListLexicons</a>) and that you spelled its name
     *         is spelled correctly. Then try again.
     * @throws ServiceFailureException
     *         An unknown condition has caused a service failure.
     * @throws MarksNotSupportedForFormatException
     *         Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only
     *         available for content in <code>json</code> format.
     * @throws SsmlMarksNotSupportedForTextTypeException
     *         SSML speech marks are not supported for plain text-type input.
     * @throws LanguageNotSupportedException
     *         The language specified is not currently supported by Amazon Polly in this capacity.
     * @throws EngineNotSupportedException
     *         This engine is not compatible with the voice that you have designated. Choose a new voice that is
     *         compatible with the engine or change the engine and restart the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PollyException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PollyClient.SynthesizeSpeech
     * @see #getObject(synthesizeSpeech, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/polly-2016-06-10/SynthesizeSpeech" target="_top">AWS API
     *      Documentation</a>
     */
    default ResponseBytes<SynthesizeSpeechResponse> synthesizeSpeechAsBytes(
            Consumer<SynthesizeSpeechRequest.Builder> synthesizeSpeechRequest) throws TextLengthExceededException,
            InvalidSampleRateException, InvalidSsmlException, LexiconNotFoundException, ServiceFailureException,
            MarksNotSupportedForFormatException, SsmlMarksNotSupportedForTextTypeException, LanguageNotSupportedException,
            EngineNotSupportedException, AwsServiceException, SdkClientException, PollyException {
        return synthesizeSpeechAsBytes(SynthesizeSpeechRequest.builder().applyMutation(synthesizeSpeechRequest).build());
    }

    /**
     * Create a {@link PollyClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PollyClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PollyClient}.
     */
    static PollyClientBuilder builder() {
        return new DefaultPollyClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PollyServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
