/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.http2.MultiplexedChannelRecord;

@SdkInternalApi
public final class ChannelAttributeKey {
    public static final AttributeKey<CompletableFuture<Protocol>> PROTOCOL_FUTURE = AttributeKey.newInstance((String)"aws.http.nio.netty.async.protocolFuture");
    public static final AttributeKey<MultiplexedChannelRecord> CHANNEL_POOL_RECORD = AttributeKey.newInstance((String)"aws.http.nio.netty.async.channelPoolRecord");
    public static final AttributeKey<Long> MAX_CONCURRENT_STREAMS = AttributeKey.newInstance((String)"aws.http.nio.netty.async.maxConcurrentStreams");
    static final AttributeKey<RequestContext> REQUEST_CONTEXT_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.requestContext");
    static final AttributeKey<Subscriber<? super ByteBuffer>> SUBSCRIBER_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.subscriber");
    static final AttributeKey<Boolean> RESPONSE_COMPLETE_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.responseComplete");
    static final AttributeKey<CompletableFuture<Void>> EXECUTE_FUTURE_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.executeFuture");
    static final AttributeKey<Long> EXECUTION_ID_KEY = AttributeKey.newInstance((String)"aws.http.nio.netty.async.executionId");
    static final AttributeKey<Boolean> KEEP_ALIVE = AttributeKey.newInstance((String)"aws.http.nio.netty.async.keepAlive");
    static final AttributeKey<Boolean> IN_USE = AttributeKey.newInstance((String)"aws.http.nio.netty.async.inUse");
    static final AttributeKey<Boolean> CLOSE_ON_RELEASE = AttributeKey.newInstance((String)"aws.http.nio.netty.async.closeOnRelease");

    private ChannelAttributeKey() {
    }

    static Protocol getProtocolNow(Channel channel) {
        return (Protocol)((CompletableFuture)(channel.parent() == null ? channel : channel.parent()).attr(PROTOCOL_FUTURE).get()).join();
    }
}

