/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the result of the evaluation of a data quality rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualityRuleResult implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualityRuleResult.Builder, DataQualityRuleResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataQualityRuleResult::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataQualityRuleResult::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EVALUATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMessage").getter(getter(DataQualityRuleResult::evaluationMessage))
            .setter(setter(Builder::evaluationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMessage").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Result")
            .getter(getter(DataQualityRuleResult::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            EVALUATION_MESSAGE_FIELD, RESULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String evaluationMessage;

    private final String result;

    private DataQualityRuleResult(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.evaluationMessage = builder.evaluationMessage;
        this.result = builder.result;
    }

    /**
     * <p>
     * The name of the data quality rule.
     * </p>
     * 
     * @return The name of the data quality rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the data quality rule.
     * </p>
     * 
     * @return A description of the data quality rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An evaluation message.
     * </p>
     * 
     * @return An evaluation message.
     */
    public final String evaluationMessage() {
        return evaluationMessage;
    }

    /**
     * <p>
     * A pass or fail status for the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link DataQualityRuleResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultAsString}.
     * </p>
     * 
     * @return A pass or fail status for the rule.
     * @see DataQualityRuleResultStatus
     */
    public final DataQualityRuleResultStatus result() {
        return DataQualityRuleResultStatus.fromValue(result);
    }

    /**
     * <p>
     * A pass or fail status for the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link DataQualityRuleResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resultAsString}.
     * </p>
     * 
     * @return A pass or fail status for the rule.
     * @see DataQualityRuleResultStatus
     */
    public final String resultAsString() {
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityRuleResult)) {
            return false;
        }
        DataQualityRuleResult other = (DataQualityRuleResult) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(evaluationMessage(), other.evaluationMessage())
                && Objects.equals(resultAsString(), other.resultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualityRuleResult").add("Name", name()).add("Description", description())
                .add("EvaluationMessage", evaluationMessage()).add("Result", resultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EvaluationMessage":
            return Optional.ofNullable(clazz.cast(evaluationMessage()));
        case "Result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityRuleResult, T> g) {
        return obj -> g.apply((DataQualityRuleResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualityRuleResult> {
        /**
         * <p>
         * The name of the data quality rule.
         * </p>
         * 
         * @param name
         *        The name of the data quality rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the data quality rule.
         * </p>
         * 
         * @param description
         *        A description of the data quality rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An evaluation message.
         * </p>
         * 
         * @param evaluationMessage
         *        An evaluation message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMessage(String evaluationMessage);

        /**
         * <p>
         * A pass or fail status for the rule.
         * </p>
         * 
         * @param result
         *        A pass or fail status for the rule.
         * @see DataQualityRuleResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityRuleResultStatus
         */
        Builder result(String result);

        /**
         * <p>
         * A pass or fail status for the rule.
         * </p>
         * 
         * @param result
         *        A pass or fail status for the rule.
         * @see DataQualityRuleResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataQualityRuleResultStatus
         */
        Builder result(DataQualityRuleResultStatus result);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String evaluationMessage;

        private String result;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityRuleResult model) {
            name(model.name);
            description(model.description);
            evaluationMessage(model.evaluationMessage);
            result(model.result);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEvaluationMessage() {
            return evaluationMessage;
        }

        public final void setEvaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
        }

        @Override
        public final Builder evaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(DataQualityRuleResultStatus result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        @Override
        public DataQualityRuleResult build() {
            return new DataQualityRuleResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
