/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class FilterConditionMapCopier {
    static Map<String, Condition> copy(Map<String, ? extends Condition> filterConditionMapParam) {
        Map<String, Condition> map;
        if (filterConditionMapParam == null || filterConditionMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Condition> modifiableMap = new LinkedHashMap<>();
            filterConditionMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Condition> copyFromBuilder(Map<String, ? extends Condition.Builder> filterConditionMapParam) {
        Map<String, Condition> map;
        if (filterConditionMapParam == null || filterConditionMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Condition> modifiableMap = new LinkedHashMap<>();
            filterConditionMapParam.forEach((key, value) -> {
                Condition member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Condition.Builder> copyToBuilder(Map<String, ? extends Condition> filterConditionMapParam) {
        Map<String, Condition.Builder> map;
        if (filterConditionMapParam == null || filterConditionMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Condition.Builder> modifiableMap = new LinkedHashMap<>();
            filterConditionMapParam.forEach((key, value) -> {
                Condition.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
