/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.SmbMountOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationSmbResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationSmbResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::locationArn)).setter(DescribeLocationSmbResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::locationUri)).setter(DescribeLocationSmbResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::agentArns)).setter(DescribeLocationSmbResponse.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("User").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::user)).setter(DescribeLocationSmbResponse.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::domain)).setter(DescribeLocationSmbResponse.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<SmbMountOptions> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MountOptions").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::mountOptions)).setter(DescribeLocationSmbResponse.setter(Builder::mountOptions)).constructor(SmbMountOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationSmbResponse.getter(DescribeLocationSmbResponse::creationTime)).setter(DescribeLocationSmbResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, AGENT_ARNS_FIELD, USER_FIELD, DOMAIN_FIELD, MOUNT_OPTIONS_FIELD, CREATION_TIME_FIELD));
    private final String locationArn;
    private final String locationUri;
    private final List<String> agentArns;
    private final String user;
    private final String domain;
    private final SmbMountOptions mountOptions;
    private final Instant creationTime;

    private DescribeLocationSmbResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.agentArns = builder.agentArns;
        this.user = builder.user;
        this.domain = builder.domain;
        this.mountOptions = builder.mountOptions;
        this.creationTime = builder.creationTime;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final String user() {
        return this.user;
    }

    public final String domain() {
        return this.domain;
    }

    public final SmbMountOptions mountOptions() {
        return this.mountOptions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationSmbResponse)) {
            return false;
        }
        DescribeLocationSmbResponse other = (DescribeLocationSmbResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationSmbResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("User", (Object)this.user()).add("Domain", (Object)this.domain()).add("MountOptions", (Object)this.mountOptions()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationSmbResponse, T> g) {
        return obj -> g.apply((DescribeLocationSmbResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private String user;
        private String domain;
        private SmbMountOptions mountOptions;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationSmbResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.agentArns(model.agentArns);
            this.user(model.user);
            this.domain(model.domain);
            this.mountOptions(model.mountOptions);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SmbMountOptions.Builder getMountOptions() {
            return this.mountOptions != null ? this.mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(SmbMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(SmbMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationSmbResponse build() {
            return new DescribeLocationSmbResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationSmbResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder user(String var1);

        public Builder domain(String var1);

        public Builder mountOptions(SmbMountOptions var1);

        default public Builder mountOptions(Consumer<SmbMountOptions.Builder> mountOptions) {
            return this.mountOptions((SmbMountOptions)((SmbMountOptions.Builder)SmbMountOptions.builder().applyMutation(mountOptions)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

