/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.UserDao;
import com.inzyme.spatiotemporal.common.dao.web.system.UserRoleDao;
import com.inzyme.spatiotemporal.common.domain.entity.UserRole;
import com.inzyme.spatiotemporal.common.domain.vo.CasUserBean;
import com.inzyme.spatiotemporal.common.domain.vo.UserVO;
import com.inzyme.spatiotemporal.common.utils.Base64Util;
import com.inzyme.spatiotemporal.common.utils.CommunicationUtils;
import com.inzyme.spatiotemporal.core.redis.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.service.system.IUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends ServiceImpl<UserDao, User>
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Value(value="${spatiotemporal.sso.casUserSyncUrl:}")
    private String casUserSyncUrl;
    @Value(value="${spatiotemporal.sso.domainName:}")
    private String domainName;
    @Value(value="${spatiotemporal.sso.systemid:}")
    private String systemid;
    @Autowired
    private RedisDao redisDao;

    public IPage<UserVO> page(UserVO userVO) {
        Long count;
        if (userVO.getOrgId() == 0L) {
            userVO.setOrgId(null);
        }
        if ((count = this.userDao.selectUserCount(userVO)) == null) {
            count = 0L;
        }
        userVO.setStartrow((userVO.getCurrent() - 1L) * userVO.getSize());
        List userList = this.userDao.selectUserList(userVO);
        Page page = new Page();
        page.setCurrent(userVO.getCurrent());
        page.setSize(userVO.getSize());
        page.setTotal(count.longValue());
        page.setRecords(userList);
        return page;
    }

    public ReturnVO<Boolean> addUser(User user) {
        if (user == null || StringUtils.isBlank((String)user.getUsername())) {
            return new ReturnVO(ReturnEnum.ERROR_USER_NULL);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"username", (Object)user.getUsername());
        if (this.userDao.selectCount((Wrapper)qw) > 0L) {
            return new ReturnVO(ReturnEnum.ERROR_EXIST_USERNAME.getCode(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        if (user.getOrgId() != null && user.getOrgId() == -1L) {
            user.setOrgId(null);
        }
        BCryptPasswordEncoder pwdEncoder = new BCryptPasswordEncoder();
        user.setPassword(pwdEncoder.encode((CharSequence)user.getPassword()));
        int insertFlag = ((UserDao)this.baseMapper).insert((Object)user);
        if (insertFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        if (user.getRoles() != null && user.getRoles().size() > 0) {
            for (String role : user.getRoles()) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId().longValue());
                userRole.setRoleId(Long.valueOf(role).longValue());
                userRoleList.add(userRole);
            }
            int insertBatchFlag = this.userRoleDao.insertBatchUserRole(userRoleList);
            if (insertBatchFlag < userRoleList.size()) {
                throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
            }
        }
        if (insertFlag > 0) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u7528\u6237\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
    }

    public ReturnVO<Boolean> updateUser(User user) {
        User oldUser = (User)((UserDao)this.baseMapper).selectById((Serializable)user.getId());
        if (!oldUser.getPassword().equals(user.getPassword())) {
            BCryptPasswordEncoder pwdEncoder = new BCryptPasswordEncoder();
            user.setPassword(pwdEncoder.encode((CharSequence)user.getPassword()));
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"username", (Object)user.getUsername());
        qw.notIn((Object)"id", new Object[]{user.getId()});
        if (this.userDao.selectCount((Wrapper)qw) > 0L) {
            return new ReturnVO(ReturnEnum.ERROR_EXIST_USERNAME.getCode(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        int updateFlag = ((UserDao)this.baseMapper).updateById((Object)user);
        if (updateFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        this.userRoleDao.deleteUserRoleByUserId(user.getId());
        if (user.getRoles() != null && user.getRoles().size() > 0) {
            ArrayList<UserRole> urList = new ArrayList<UserRole>();
            for (String role : user.getRoles()) {
                UserRole ur = new UserRole();
                ur.setRoleId(Long.valueOf(role).longValue());
                ur.setUserId(user.getId().longValue());
                urList.add(ur);
            }
            int insertBatchFlag = this.userRoleDao.insertBatchUserRole(urList);
            if (insertBatchFlag < urList.size()) {
                throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
            }
        }
        if (updateFlag > 0) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u7528\u6237\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
    }

    public ReturnVO<Boolean> deleteUser(Long userId) {
        int cnt = ((UserDao)this.baseMapper).deleteById((Serializable)userId);
        if (cnt < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u5220\u9664\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
        }
        cnt = this.userRoleDao.deleteUserRoleByUserId(userId);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    public User getUser(Long userId) {
        User user = (User)((UserDao)this.baseMapper).selectById((Serializable)userId);
        BCryptPasswordEncoder pwdEncoder = new BCryptPasswordEncoder();
        List urList = this.userRoleDao.getUserRoleListByUserId(userId);
        ArrayList<String> roles = new ArrayList<String>();
        for (UserRole ur : urList) {
            roles.add(String.valueOf(ur.getRoleId()));
        }
        user.setRoles(roles);
        return user;
    }

    public ReturnVO<Boolean> userSyncToCenter(String casToken) {
        ReturnVO returnVO = new ReturnVO();
        HashMap header = new HashMap();
        try {
            List list = this.userDao.selectAllUserInfo();
            for (CasUserBean bean : list) {
                bean.setPassword(Base64Util.getBASE64((String)bean.getPassword()));
            }
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("appId", this.systemid);
            requestMap.put("type", "add");
            requestMap.put("access-token", casToken);
            requestMap.put("users", list);
            String reqJson = JSONObject.toJSONString(requestMap);
            log.info("\u7528\u6237\u6570\u636e\u540c\u6b65\u8bf7\u6c42\u5730\u5740:{}", (Object)this.casUserSyncUrl);
            log.info("\u7528\u6237\u6570\u636e\u540c\u6b65\u8bf7\u6c42\u53c2\u6570:{}", (Object)reqJson);
            String responseJson = CommunicationUtils.postHttp((String)this.casUserSyncUrl, (String)reqJson, header);
            log.info("\u7528\u6237\u6570\u636e\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)responseJson);
            JSONObject jsonObject = JSONObject.parseObject((String)responseJson);
            returnVO.setCode(ReturnEnum.SUCCESS.getCode());
            returnVO.setMsg("\u7528\u6237\u6570\u636e\u540c\u6b65\u63a5\u53e3\u8c03\u7528\u6210\u529f");
            returnVO.setData((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u6570\u636e\u540c\u6b65\u63a5\u53e3\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            returnVO.setCode(ReturnEnum.FAILED.getCode());
            returnVO.setMsg("\u7528\u6237\u6570\u636e\u540c\u6b65\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        return returnVO;
    }

    public ReturnVO<Void> ssoUser(String token, String username, String password) {
        try {
            String osuser = this.redisDao.getString("spatiotemporal:cas:token:" + token);
            if (osuser == null) {
                log.info("access-token\u5df2\u5931\u6548\u6216\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728, access-token: {} ", (Object)("spatiotemporal:cas:token:" + token));
                return new ReturnVO(ReturnEnum.ERROR_USER_NOT_ENABLED.getCode(), "access-token\u5df2\u5931\u6548\u6216\u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728");
            }
            User user = new User();
            user.setUsername(username);
            user.setPassword(password);
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"username", (Object)user.getUsername());
            if (this.userDao.selectCount((Wrapper)qw) > 0L) {
                return new ReturnVO(ReturnEnum.ERROR_EXIST_USERNAME.getCode(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u6b64\u7528\u6237\u540d\u5df2\u5b58\u5728");
            }
            if (user.getOrgId() != null && user.getOrgId() == -1L) {
                user.setOrgId(null);
            }
            BCryptPasswordEncoder pwdEncoder = new BCryptPasswordEncoder();
            user.setPassword(pwdEncoder.encode((CharSequence)user.getPassword()));
            int insertFlag = ((UserDao)this.baseMapper).insert((Object)user);
            if (insertFlag < 1) {
                return new ReturnVO("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002");
            }
            if (insertFlag > 0) {
                return new ReturnVO("801", "\u63a8\u9001\u6210\u529f");
            }
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u7528\u6237\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u63a8\u9001\u8c03\u7528\u5f02\u5e38:{}", (Throwable)e);
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u7528\u6237\u63a8\u9001\u8c03\u7528\u5931\u8d25");
        }
    }
}

