/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.UserInfoDao;
import com.inzyme.spatiotemporal.common.domain.entity.UserInfo;
import com.inzyme.spatiotemporal.core.config.ftp.FtpProperties;
import com.inzyme.spatiotemporal.web.core.utils.FtpUtils;
import com.inzyme.spatiotemporal.web.service.system.IUserInfoService;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserInfoServiceImpl
extends ServiceImpl<UserInfoDao, UserInfo>
implements IUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    @Value(value="${spatiotemporal.web.admin.ftp.avatar-path:/avatars}")
    private String avatarPath;
    @Autowired
    FtpProperties ftpProperties;
    @Autowired
    UserInfoDao userInfoDao;

    public String upload(MultipartFile file) {
        FtpUtils ftpUtils = new FtpUtils(this.ftpProperties.getIp(), Integer.valueOf(this.ftpProperties.getPort()).intValue(), this.ftpProperties.getUsername(), this.ftpProperties.getPassword());
        String fileName = file.getOriginalFilename();
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        String uuidFileName = UUID.randomUUID().toString() + suffix;
        InputStream in = null;
        try {
            in = file.getInputStream();
            ftpUtils.uploadFile(this.avatarPath, uuidFileName, in);
            return this.avatarPath + "/" + uuidFileName;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return null;
        }
    }

    public UserInfo getUserInfo(Long userId) {
        return this.userInfoDao.getUserInfoByUserId(userId);
    }
}

