/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.RoleDao;
import com.inzyme.spatiotemporal.common.dao.web.system.RoleMenuDao;
import com.inzyme.spatiotemporal.common.domain.entity.Role;
import com.inzyme.spatiotemporal.common.domain.entity.RoleMenu;
import com.inzyme.spatiotemporal.common.domain.vo.RoleVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.service.system.IRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl
extends ServiceImpl<RoleDao, Role>
implements IRoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RoleMenuDao roleMenuDao;

    @Transactional
    public IPage<Role> pageRole(RoleVO roleVO) {
        QueryWrapper querywrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)roleVO.getRoleName())) {
            querywrapper.like((Object)"name", (Object)roleVO.getRoleName());
        }
        querywrapper.eq((Object)"is_deleted", (Object)0);
        Page rolePage = new Page();
        if (roleVO.getSize() == 0L) {
            List roleList = ((RoleDao)this.baseMapper).selectList((Wrapper)querywrapper);
            rolePage.setRecords(roleList);
            rolePage.setTotal((long)roleList.size());
            return rolePage;
        }
        rolePage.setSize(roleVO.getSize());
        rolePage.setCurrent(roleVO.getCurrent());
        rolePage = ((RoleDao)this.baseMapper).selectPage((IPage)rolePage, (Wrapper)querywrapper);
        return rolePage;
    }

    public List<RoleMenu> getMenuIdListByRoleId(Long roleId) {
        return this.roleDao.selectMenuListByRoleId(roleId);
    }

    @Transactional
    public boolean saveRolePermission(RoleVO roleVO) {
        Integer insertFlag;
        log.info("\u5206\u914d\u89d2\u8272\u6743\u9650");
        if (null == roleVO || null == roleVO.getRoleId()) {
            log.debug("\u89d2\u8272id\u4e3a\u7a7a\uff01");
            return false;
        }
        Long roleId = roleVO.getRoleId();
        List selectedMenus = roleVO.getSelectedMenuIds();
        List halfMenuIds = roleVO.getHalfMenuIds();
        ArrayList<RoleMenu> list = new ArrayList<RoleMenu>();
        for (RoleMenu rm : selectedMenus) {
            rm.setRoleId(roleId);
            rm.setSelectedStatus("1");
            list.add(rm);
        }
        for (RoleMenu rm : halfMenuIds) {
            rm.setRoleId(roleId);
            rm.setSelectedStatus("0");
            list.add(rm);
        }
        this.roleMenuDao.deleteRoleMenuByRoleId(roleId);
        if (list.size() > 0 && (insertFlag = this.roleMenuDao.insertBatchRoleMenu(list)) < list.size()) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u5931\u8d25\u3002");
        }
        return true;
    }

    public boolean insertRole(Role role) {
        int insertFlag = this.roleDao.insert((Object)role);
        if (insertFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u89d2\u8272\u4fe1\u606f\u5931\u8d25\u3002");
        }
        return true;
    }

    public boolean updateRole(Role role) {
        Role oldRole = (Role)this.roleDao.selectById((Serializable)role.getId());
        oldRole.setCode(role.getCode());
        oldRole.setName(role.getName());
        oldRole.setDescription(role.getDescription());
        int updateFlag = this.roleDao.updateById((Object)oldRole);
        if (updateFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u66f4\u65b0\u89d2\u8272\u4fe1\u606f\u5931\u8d25\u3002");
        }
        return true;
    }

    public boolean deleteRole(Long roleId) {
        Role role = (Role)this.roleDao.selectById((Serializable)roleId);
        role.setDeleted(Integer.valueOf(1));
        int updateFlag = this.roleDao.updateById((Object)role);
        if (updateFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u5220\u9664\u89d2\u8272\u4fe1\u606f\u5931\u8d25\u3002");
        }
        return true;
    }
}

