/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.OrgDao;
import com.inzyme.spatiotemporal.common.domain.entity.Org;
import com.inzyme.spatiotemporal.common.utils.CodeUtils;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import com.inzyme.spatiotemporal.web.service.system.IOrgService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgServiceImpl
extends ServiceImpl<OrgDao, Org>
implements IOrgService {
    private static final Logger log = LoggerFactory.getLogger(OrgServiceImpl.class);

    public void addOrg(Org org) {
        Org parent = null;
        if (org.getParentId() != null && (parent = (Org)((OrgDao)this.baseMapper).selectById((Serializable)org.getParentId())) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u3002");
        }
        org.setCode(this.generateOrgCode(parent));
        if (((OrgDao)this.baseMapper).insert((Object)org) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u5931\u8d25\u3002");
        }
    }

    public List<Org> querySubOrgs(Long parentId) {
        QueryWrapper wrapper = new QueryWrapper();
        if (parentId == null) {
            wrapper.isNull((Object)"parent_id");
        } else {
            wrapper.eq((Object)"parent_id", (Object)parentId);
        }
        wrapper.orderByAsc((Object)"parent_id");
        wrapper.orderByAsc((Object)"order_no");
        return ((OrgDao)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<Org> queryTrees(Long parentId) {
        Org parent = null;
        if (parentId != null && (parent = (Org)((OrgDao)this.baseMapper).selectById((Serializable)parentId)) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u3002");
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (parent != null) {
            wrapper.likeLeft((Object)"code", (Object)parent.getCode());
        }
        wrapper.orderByAsc((Object)"parent_id", (Object[])new String[]{"order_no"});
        return TreeUtils.list2Tree((List)((OrgDao)this.baseMapper).selectList((Wrapper)wrapper));
    }

    private String generateOrgCode(Org parent) {
        QueryWrapper wrapper = new QueryWrapper();
        if (parent == null) {
            wrapper.isNull((Object)"parent_id");
        } else {
            wrapper.eq((Object)"parent_id", (Object)parent.getId());
        }
        wrapper.orderByDesc((Object)"code");
        wrapper.last("limit 1");
        Org last = (Org)((OrgDao)this.baseMapper).selectOne((Wrapper)wrapper);
        if (last != null) {
            return CodeUtils.generateSameLevelCode((String)last.getCode());
        }
        if (parent != null) {
            return CodeUtils.generateNextLevelCode((String)parent.getCode());
        }
        return CodeUtils.generateNextLevelCode((String)"");
    }

    public Boolean queryRepetition(Org org) {
        log.info("\u67e5\u8be2\u662f\u5426\u91cd\u590d >>> {}", (Object)org);
        if (org.getParentId() == null || org.getParentId() <= 0L) {
            List parentList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.isNull((Object)"parent_id")).eq((Object)"name", (Object)org.getName());
            if (org.getId() != null) {
                qw.notIn((Object)"id", new Object[]{org.getId()});
            }
            if ((parentList = ((OrgDao)this.baseMapper).selectList((Wrapper)qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                return true;
            }
        } else {
            List orgList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.eq((Object)"name", (Object)org.getName())).eq((Object)"parent_id", (Object)org.getParentId());
            if (org.getId() != null) {
                qw.notIn((Object)"id", new Object[]{org.getId()});
            }
            if ((orgList = ((OrgDao)this.baseMapper).selectList((Wrapper)qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                return true;
            }
        }
        return false;
    }
}

