/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.MenuDao;
import com.inzyme.spatiotemporal.common.dao.web.system.MenuIconDao;
import com.inzyme.spatiotemporal.common.domain.entity.Menu;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import com.inzyme.spatiotemporal.web.service.system.IDictService;
import com.inzyme.spatiotemporal.web.service.system.IMenuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends ServiceImpl<MenuDao, Menu>
implements IMenuService {
    private static final Logger log = LoggerFactory.getLogger(MenuServiceImpl.class);
    @Autowired
    private IDictService dictService;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    public MenuIconDao menuIconDao;
    private static List<Long> waitForDeleteMenuIds = null;

    public List<Menu> queryTrees() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByAsc((Object)"parent_id", (Object[])new String[]{"order_no"});
        List list = ((MenuDao)this.baseMapper).selectList((Wrapper)wrapper);
        Map menuTypeDict = this.dictService.getDictItemsByDictType("menuType");
        if (menuTypeDict != null) {
            for (Menu menu : list) {
                if (menu.getMenuType() == null) continue;
                menu.setTypeName((String)menuTypeDict.get(menu.getMenuType().toString()));
            }
        }
        return TreeUtils.list2Tree((List)list);
    }

    public Boolean queryRepetition(Menu menu) {
        log.info("\u67e5\u8be2\u4f20\u5165\u7684\u6570\u636e\u662f\u5426\u91cd\u590d >>> {}", (Object)menu);
        List resultList = new ArrayList();
        if (menu.getMenuType() == null) {
            if (menu.getParentId() == null || menu.getParentId() <= 0L) {
                menu.setMenuType(Integer.valueOf(1));
            } else {
                Menu parent = (Menu)this.menuDao.selectById((Serializable)menu.getParentId());
                if (parent.getMenuType() == 1) {
                    menu.setMenuType(Integer.valueOf(2));
                }
                if (parent.getMenuType() == 2) {
                    menu.setMenuType(Integer.valueOf(3));
                }
                if (parent.getMenuType() == 3) {
                    menu.setMenuType(Integer.valueOf(3));
                }
            }
        }
        resultList = menu.getParentId() == null || menu.getParentId() <= 0L ? this.menuDao.queryRepetitionFu(menu) : this.menuDao.queryRepetitionZi(menu);
        log.info("\u6709\u91cd\u590d\u7684\u83dc\u5355\u9879\u5417\uff1a{}", (Object)(resultList.size() >= 1 ? 1 : 0));
        if (resultList.size() >= 1) {
            return true;
        }
        return false;
    }

    public void removeMenusByIds(List<Long> ids) {
        if (null == waitForDeleteMenuIds) {
            waitForDeleteMenuIds = new ArrayList();
        }
        for (Long id : ids) {
            this.removeChildMenus(id);
        }
        log.info("\u5220\u9664\u83dc\u5355 >>> {} \u6761", (Object)waitForDeleteMenuIds.size());
        this.menuDao.deleteBatchIds((Collection)waitForDeleteMenuIds);
        waitForDeleteMenuIds = null;
        log.info("\u5220\u9664\u83dc\u5355\u6267\u884c\u5b8c\u6bd5");
    }

    private void removeChildMenus(Long id) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"parent_id", (Object)id);
        List childMenus = this.menuDao.selectList((Wrapper)qw);
        for (Menu menu : childMenus) {
            this.removeChildMenus(menu.getId());
        }
        waitForDeleteMenuIds.add(id);
    }
}

