/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.inzyme.spatiotemporal.common.dao.web.system.MenuDao;
import com.inzyme.spatiotemporal.common.dao.web.system.RoleDao;
import com.inzyme.spatiotemporal.common.dao.web.system.UserDao;
import com.inzyme.spatiotemporal.common.domain.vo.CasUserLoginBean;
import com.inzyme.spatiotemporal.common.domain.vo.LoginVO;
import com.inzyme.spatiotemporal.common.utils.CommunicationUtils;
import com.inzyme.spatiotemporal.core.redis.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.Authority;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.JwtTokenUtils;
import com.inzyme.spatiotemporal.web.service.system.ILoginService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements ILoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceImpl.class);
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    private RedisDao redisDao;
    @Value(value="${spatiotemporal.sso.casUserLoginUrl:}")
    private String casUserLoginUrl;
    @Value(value="${spatiotemporal.sso.domainName:}")
    private String domainName;
    @Value(value="${spatiotemporal.sso.systemid:}")
    private String systemid;

    public User login(LoginVO vo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"username", (Object)vo.getUsername());
        User user = (User)this.userDao.selectOne((Wrapper)queryWrapper);
        if (user == null) {
            throw new BaseBusinessException(ReturnEnum.ERROR_ACCOUNT_OR_PASSWORD);
        }
        if (user.getDeleted() == null || user.getDeleted() == 1) {
            log.info("\u7528\u6237\u5df2\u5220\u9664  {}", (Object)user.getDeleted());
            throw new BaseBusinessException(ReturnEnum.ERROR_USER_NOT_EXIST);
        }
        if (user.isEnabled()) {
            log.info("\u7528\u6237\u5df2\u505c\u7528  {}", (Object)user.isEnabled());
            throw new BaseBusinessException(ReturnEnum.ERROR_USER_NOT_ENABLED);
        }
        BCryptPasswordEncoder pwdEncoder = new BCryptPasswordEncoder();
        if (!pwdEncoder.matches((CharSequence)vo.getPassword(), user.getPassword())) {
            throw new BaseBusinessException(ReturnEnum.ERROR_ACCOUNT_OR_PASSWORD);
        }
        List roleList = this.roleDao.selectUserRoles(user.getId());
        ArrayList roleIds = new ArrayList();
        ArrayList roles = new ArrayList();
        roleList.forEach(role -> {
            roleIds.add(role.getId());
            roles.add(role.getCode());
        });
        user.setRoles(roles);
        List menus = null;
        menus = "admin".equals(vo.getUsername()) ? this.menuDao.selectList(null) : (roleIds == null || roleIds.size() == 0 ? new ArrayList() : this.menuDao.selectRoleMenus(roleIds));
        ArrayList authorities = new ArrayList();
        ArrayList permissions = new ArrayList();
        menus.forEach(menu -> {
            authorities.add(new Authority(menu.getName(), menu.getMenuType()));
            permissions.add(menu.getName());
        });
        user.setAuthorities(authorities);
        user.setPermissions(permissions);
        return user;
    }

    public void logout(String token) {
        String username = JwtTokenUtils.parseToken((String)token);
        this.redisDao.del(new String[]{token});
        this.redisDao.del(new String[]{"spatiotemporal:username:" + username});
    }

    public boolean changePassword(LoginVO vo) {
        return false;
    }

    public String getVerifyCode(LoginVO vo) {
        return null;
    }

    public User casLogin(String token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("appId", this.systemid);
        header.put("domain", this.domainName);
        CasUserLoginBean bean = new CasUserLoginBean();
        bean.setAppId(this.systemid);
        bean.setToken(token);
        String requestJson = JSONObject.toJSONString((Object)bean);
        log.info("\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u53c2\u6570:{}", (Object)requestJson);
        log.info("\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u5730\u5740:{}", (Object)this.casUserLoginUrl);
        try {
            String responseJson = CommunicationUtils.postHttp((String)this.casUserLoginUrl, (String)requestJson, header);
            JSONObject resJson = JSONObject.parseObject((String)responseJson);
            log.info("\u5355\u70b9\u767b\u5f55\u8ba4\u8bc1\u8fd4\u56de\u7ed3\u679c:{}", (Object)responseJson);
            if (StringUtils.isBlank((String)responseJson)) {
                throw new BaseBusinessException("400", "\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            if (resJson.get((Object)"code") == null) {
                throw new BaseBusinessException("400", "\u5355\u70b9\u767b\u5f55\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u7f16\u7801\u4e3a\u7a7a");
            }
            String code = resJson.getString("code");
            if (!"801".equals(code)) {
                throw new BaseBusinessException("400", resJson.getString("msg"));
            }
            JSONObject data = resJson.getJSONObject("data");
            JSONObject userJson = data.getJSONObject("user");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"username", (Object)userJson.getString("username"));
            User user = (User)this.userDao.selectOne((Wrapper)queryWrapper);
            user.setAccessToken(data.getString("access-token"));
            if (user == null) {
                throw new BaseBusinessException(ReturnEnum.ERROR_ACCOUNT_OR_PASSWORD);
            }
            if (user.getDeleted() == null || user.getDeleted() == 1) {
                log.info("\u7528\u6237\u5df2\u5220\u9664  {}", (Object)user.getDeleted());
                throw new BaseBusinessException(ReturnEnum.ERROR_USER_NOT_EXIST);
            }
            if (user.isEnabled()) {
                log.info("\u7528\u6237\u5df2\u505c\u7528  {}", (Object)user.isEnabled());
                throw new BaseBusinessException(ReturnEnum.ERROR_USER_NOT_ENABLED);
            }
            List roleList = this.roleDao.selectUserRoles(user.getId());
            ArrayList roleIds = new ArrayList();
            ArrayList roles = new ArrayList();
            roleList.forEach(role -> {
                roleIds.add(role.getId());
                roles.add(role.getCode());
            });
            user.setRoles(roles);
            List menus = null;
            menus = "admin".equals(user.getUsername()) ? this.menuDao.selectList(null) : (roleIds == null || roleIds.size() == 0 ? new ArrayList() : this.menuDao.selectRoleMenus(roleIds));
            ArrayList authorities = new ArrayList();
            ArrayList permissions = new ArrayList();
            menus.forEach(menu -> {
                authorities.add(new Authority(menu.getName(), menu.getMenuType()));
                permissions.add(menu.getName());
            });
            user.setAuthorities(authorities);
            user.setPermissions(permissions);
            return user;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5355\u70b9\u767b\u5f55\u63a5\u53e3\u5f02\u5e38:{}", (Throwable)e);
            return null;
        }
    }
}

