/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.DictDao;
import com.inzyme.spatiotemporal.common.domain.entity.Dict;
import com.inzyme.spatiotemporal.core.redis.RedisDao;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import com.inzyme.spatiotemporal.web.service.system.IDictService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
extends ServiceImpl<DictDao, Dict>
implements IDictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    @Autowired
    private RedisDao redisDao;

    public boolean removeById(Serializable id) {
        Dict dict = (Dict)((DictDao)this.baseMapper).selectById(id);
        if (dict == null) {
            throw new BaseBusinessException("603", "\u8981\u5220\u9664\u6570\u636e\u5b57\u5178\u9879\u5df2\u4e0d\u5b58\u5728\u3002");
        }
        if (((DictDao)this.baseMapper).deleteById(id) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u5220\u9664\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002");
        }
        if (StringUtils.isNotEmpty((String)dict.getDictType())) {
            Map subDict = (Map)this.redisDao.template().opsForHash().get((Object)"spatiotemporal\\:dict\\:list", (Object)dict.getDictType());
            if (subDict != null) {
                subDict.remove(dict.getValue());
                this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{dict.getDictType()});
                this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", dict.getDictType(), (Object)subDict);
            }
        } else {
            this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{dict.getValue()});
        }
        return true;
    }

    public void addDict(Dict dict) {
        Dict parent = null;
        if (dict.getParentId() != null && (parent = (Dict)((DictDao)this.baseMapper).selectById((Serializable)dict.getParentId())) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728\u3002");
        }
        if (((DictDao)this.baseMapper).insert((Object)dict) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002");
        }
        if (StringUtils.isNotEmpty((String)dict.getDictType())) {
            Map subDict = (Map)this.redisDao.template().opsForHash().get((Object)"spatiotemporal\\:dict\\:list", (Object)dict.getDictType());
            if (subDict != null) {
                subDict.put(dict.getValue(), dict.getLabel());
                this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{dict.getDictType()});
                this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", dict.getDictType(), (Object)subDict);
            }
        } else {
            this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", dict.getValue(), new HashMap());
        }
    }

    public void updateDict(Dict dict) {
        Dict parent = null;
        Dict oldDict = (Dict)((DictDao)this.baseMapper).selectById((Serializable)dict.getId());
        if (dict.getParentId() != null && (parent = (Dict)((DictDao)this.baseMapper).selectById((Serializable)dict.getParentId())) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728\u3002");
        }
        if (((DictDao)this.baseMapper).updateById((Object)dict) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u66f4\u65b0\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002");
        }
        if (dict.getParentId() == null) {
            int line = ((DictDao)this.baseMapper).updateDictChildType(dict);
            log.info("\u540c\u6b65\u4fee\u6539\u6570\u636e\u5b57\u5178\u5b50\u7ea7dict_type ,\u5f71\u54cd\u884c\u6570 -> {}", (Object)line);
        }
        if (StringUtils.isNotEmpty((String)oldDict.getDictType())) {
            Map subDict = (Map)this.redisDao.template().opsForHash().get((Object)"spatiotemporal\\:dict\\:list", (Object)dict.getDictType());
            if (subDict != null) {
                subDict.remove(oldDict.getValue());
                this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{oldDict.getDictType()});
                this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", oldDict.getDictType(), (Object)subDict);
            }
        } else {
            this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{oldDict.getValue()});
        }
        if (StringUtils.isNotEmpty((String)dict.getDictType())) {
            Map subDict = (Map)this.redisDao.template().opsForHash().get((Object)"spatiotemporal\\:dict\\:list", (Object)dict.getDictType());
            if (subDict != null) {
                subDict.put(dict.getValue(), dict.getLabel());
                this.redisDao.delHashItem("spatiotemporal\\:dict\\:list", new Object[]{dict.getDictType()});
                this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", dict.getDictType(), (Object)subDict);
            }
        } else {
            this.redisDao.putHashValue("spatiotemporal\\:dict\\:list", dict.getValue(), new HashMap());
        }
    }

    public List<Dict> queryTrees(Long parentId) {
        Dict parent = null;
        if (parentId != null && (parent = (Dict)((DictDao)this.baseMapper).selectById((Serializable)parentId)) == null) {
            throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u3002");
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (parent != null) {
            wrapper.likeLeft((Object)"dict_type", (Object)parent.getDictType());
        }
        wrapper.orderByAsc((Object)"parent_id");
        wrapper.orderByAsc((Object)"order_no");
        return TreeUtils.list2Tree((List)((DictDao)this.baseMapper).selectList((Wrapper)wrapper));
    }

    public Map<String, Map<String, String>> selectAllDict() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByAsc((Object)"parent_id");
        wrapper.orderByAsc((Object)"order_no");
        wrapper.eq((Object)"is_deleted", (Object)0);
        wrapper.eq((Object)"is_hidden", (Object)0);
        List dictList = ((DictDao)this.baseMapper).selectList((Wrapper)wrapper);
        HashMap<String, Map<String, String>> dictMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> dictItemMap = null;
        for (Dict dict : dictList) {
            if (dict.getParentId() == null && !dictMap.containsKey(dict.getValue())) {
                dictItemMap = new HashMap<String, String>();
                dictMap.put(dict.getValue(), dictItemMap);
                continue;
            }
            dictItemMap = dictMap.containsKey(dict.getDictType()) ? (Map)dictMap.get(dict.getDictType()) : new HashMap();
            dictItemMap.put(dict.getValue(), dict.getLabel());
        }
        return dictMap;
    }

    public Map<String, String> getDictItemsByDictType(String code) {
        return (Map)this.redisDao.template().opsForHash().get((Object)"spatiotemporal\\:dict\\:list", (Object)code);
    }

    public Boolean queryRepetition(Dict dict) {
        log.info("\u67e5\u8be2\u662f\u5426\u91cd\u590d >>> {}", (Object)dict);
        if (dict.getParentId() == null || dict.getParentId() <= 0L) {
            List parentList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.isNull((Object)"parent_id")).eq((Object)"value", (Object)dict.getValue());
            if (dict.getId() != null) {
                qw.notIn((Object)"id", new Object[]{dict.getId()});
            }
            if ((parentList = ((DictDao)this.baseMapper).selectList((Wrapper)qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                return true;
            }
        } else {
            List dictList;
            QueryWrapper qw = new QueryWrapper();
            ((QueryWrapper)qw.eq((Object)"value", (Object)dict.getValue())).eq((Object)"parent_id", (Object)dict.getParentId());
            if (dict.getId() != null) {
                qw.notIn((Object)"id", new Object[]{dict.getId()});
            }
            if ((dictList = ((DictDao)this.baseMapper).selectList((Wrapper)qw)).size() >= 1) {
                log.info("\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
                return true;
            }
        }
        return false;
    }
}

