/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.inzyme.spatiotemporal.core.redis.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.utils.JwtTokenUtils;
import com.inzyme.spatiotemporal.web.service.system.IAuthService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetailsService;

public class AuthServiceImpl
implements IAuthService {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private RedisDao redisDao;

    public User login(String username, String password) {
        Authentication authentication = this.authenticate(username, password);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        User user = (User)authentication.getPrincipal();
        return user;
    }

    public void logout(String token) {
        String username = JwtTokenUtils.parseToken((String)token);
        this.redisDao.del(new String[]{token});
        this.redisDao.del(new String[]{"spatiotemporal:username:" + username});
    }

    public User refresh(String token) {
        String username = JwtTokenUtils.parseToken((String)token);
        User userDetail = (User)this.userDetailsService.loadUserByUsername(username);
        return userDetail;
    }

    public User getUserByToken(String token) {
        return (User)AuthorityUtils.getCurrentUser((String)token);
    }

    private Authentication authenticate(String username, String password) {
        try {
            return this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        }
        catch (BadCredentialsException | DisabledException | InternalAuthenticationServiceException e) {
            throw new BaseBusinessException(ReturnEnum.ERROR_ACCOUNT_OR_PASSWORD);
        }
    }
}

