/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.service.system.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.inzyme.spatiotemporal.common.dao.web.system.AreaDao;
import com.inzyme.spatiotemporal.common.domain.entity.Area;
import com.inzyme.spatiotemporal.common.domain.vo.AreaVO;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import com.inzyme.spatiotemporal.web.service.system.IAreaService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AreaServiceImpl
extends ServiceImpl<AreaDao, Area>
implements IAreaService {
    public List<Area> queryTrees(Long parentId) {
        Area parent = null;
        if (parentId != null && parentId != 0L) {
            QueryWrapper selectOneQW = new QueryWrapper();
            selectOneQW.eq((Object)"area_code", (Object)parentId);
            parent = (Area)((AreaDao)this.baseMapper).selectOne((Wrapper)selectOneQW);
            if (parent == null) {
                throw new BaseBusinessException("601", "\u6240\u6307\u5b9a\u7684\u4e0a\u7ea7\u533a\u57df\u4e0d\u5b58\u5728\u3002");
            }
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (parent != null) {
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"parent_code", (Object)parent.getAreaCode())).or()).eq((Object)"area_code", (Object)parent.getAreaCode());
        }
        wrapper.eq((Object)"status", (Object)1);
        wrapper.orderByAsc((Object)"parent_code", (Object[])new String[]{"order_num"});
        return TreeUtils.list2Tree((List)((AreaDao)this.baseMapper).selectList((Wrapper)wrapper));
    }

    public List<Area> querySubAreas(Long parentId) {
        return null;
    }

    public IPage<Area> page(AreaVO areaVO) {
        QueryWrapper qw = new QueryWrapper();
        if (null != areaVO) {
            if (StringUtils.isNotEmpty((String)areaVO.getName())) {
                qw.like((Object)"name", (Object)areaVO.getName());
            } else if (StringUtils.isNotEmpty((String)areaVO.getParentCode())) {
                qw.eq((Object)"parent_code", (Object)areaVO.getParentCode());
            }
        }
        qw.orderByAsc((Object)"layer", (Object[])new String[]{"order_num"});
        IPage page = ((AreaDao)this.baseMapper).selectPage((IPage)new Page(areaVO.getCurrent(), areaVO.getSize()), (Wrapper)qw);
        return page;
    }

    public ReturnVO<Boolean> addArea(Area area) {
        if (null == area || StringUtils.isEmpty((String)area.getName())) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"area_code", (Object)area.getAreaCode());
        if (((AreaDao)this.baseMapper).selectCount((Wrapper)qw) > 0L) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u533a\u57df\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
        }
        Date date = new Date();
        area.setGmtCreate(date);
        area.setGmtModified(date);
        int insertFlag = ((AreaDao)this.baseMapper).insert((Object)area);
        if (insertFlag < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u65b0\u589e\u533a\u57df\u4fe1\u606f\u5931\u8d25\u3002");
        }
        if (insertFlag > 0) {
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u533a\u57df\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
    }

    public ReturnVO<Area> getAreaById(Long areaId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"area_id", (Object)areaId);
        return new ReturnVO(ReturnEnum.SUCCESS, ((AreaDao)this.baseMapper).selectOne((Wrapper)qw));
    }

    public ReturnVO<Boolean> updateArea(Area area) {
        if (null == area || null == area.getAreaId()) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM);
        }
        QueryWrapper getOldQw = new QueryWrapper();
        getOldQw.eq((Object)"area_id", (Object)area.getAreaId());
        Area old = (Area)((AreaDao)this.baseMapper).selectOne((Wrapper)getOldQw);
        if (StringUtils.isNotEmpty((String)area.getAreaCode())) {
            if (!old.getAreaCode().equals(area.getAreaCode())) {
                QueryWrapper qw = new QueryWrapper();
                qw.eq((Object)"area_code", (Object)area.getAreaCode());
                if (((AreaDao)this.baseMapper).selectCount((Wrapper)qw) > 0L) {
                    return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u533a\u57df\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
                }
            }
            old.setAreaCode(area.getAreaCode());
        }
        if (StringUtils.isNotEmpty((String)area.getParentCode())) {
            old.setParentCode(area.getParentCode());
        }
        if (StringUtils.isNotEmpty((String)area.getName())) {
            old.setName(area.getName());
        }
        if (null != area.getStatus() && (area.getStatus() == 1 || area.getStatus() == 0)) {
            old.setStatus(area.getStatus());
        }
        if (null != area.getOrderNum()) {
            old.setOrderNum(area.getOrderNum());
        }
        if (null != area.getLayer()) {
            old.setLayer(area.getLayer());
        }
        old.setRemark(area.getRemark());
        old.setGmtModified(new Date());
        int updateFlag = ((AreaDao)this.baseMapper).update((Object)old, (Wrapper)getOldQw);
        return new ReturnVO((Object)(updateFlag > 0 ? 1 : 0));
    }

    public ReturnVO<Boolean> deleteArea(Long areaId) {
        if (null == areaId) {
            return new ReturnVO(ReturnEnum.ERROR_POST_PARAM);
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"area_id", (Object)areaId);
        int deleteFlag = ((AreaDao)this.baseMapper).delete((Wrapper)qw);
        return new ReturnVO((Object)(deleteFlag > 0 ? 1 : 0));
    }
}

