/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.inzyme.spatiotemporal.common.domain.entity.UserInfo;
import com.inzyme.spatiotemporal.common.domain.vo.UserVO;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import com.inzyme.spatiotemporal.web.service.system.IUserInfoService;
import com.inzyme.spatiotemporal.web.service.system.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/admin/user"})
@Api(tags={"\u7cfb\u7edf\u7528\u6237\u7ba1\u7406"})
public class UserController {
    @Autowired
    private IUserService userService;
    @Autowired
    private IUserInfoService userInfoService;

    @UserLog(value="\u7528\u6237\u5217\u8868")
    @ApiOperation(value="\u7528\u6237\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<UserVO>> page(@RequestBody @ApiParam UserVO userVO) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.page(userVO));
    }

    @UserLog(value="\u5f97\u5230\u7528\u6237\u4fe1\u606f")
    @ApiOperation(value="\u5f97\u5230\u7528\u6237\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/getUser"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<User> page(@RequestParam(value="userId") @ApiParam Long userId) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userService.getUser(userId));
    }

    @UserLog(value="\u65b0\u589e\u7528\u6237")
    @ApiOperation(value="\u65b0\u589e\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="userManage", name="\u65b0\u589e\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> add(@RequestBody @ApiParam User user) {
        return this.userService.addUser(user);
    }

    @UserLog(value="\u66f4\u65b0\u7528\u6237")
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="userManage", name="\u7f16\u8f91\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> update(@RequestBody @ApiParam User user) {
        return this.userService.updateUser(user);
    }

    @UserLog(value="\u5220\u9664\u7528\u6237")
    @ApiOperation(value="\u5220\u9664\u7528\u6237", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @PermissionSource(code="userManage", name="\u5220\u9664\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> delete(@RequestParam(value="userId") @ApiParam Long userId) {
        return this.userService.deleteUser(userId);
    }

    @UserLog(value="\u4e0a\u4f20\u7528\u6237\u5934\u50cf")
    @ApiOperation(value="\u4e0a\u4f20\u7528\u6237\u5934\u50cf", notes="\u65e0")
    @PostMapping(value={"/upload"})
    public ReturnVO<?> upload(@RequestPart(value="file") MultipartFile file) {
        String uploadPath = this.userInfoService.upload(file);
        if (StringUtils.isNotEmpty((CharSequence)uploadPath)) {
            return new ReturnVO(ReturnEnum.SUCCESS, (Object)uploadPath);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u4e0a\u4f20\u7528\u6237\u5934\u50cf\u5931\u8d25");
    }

    @UserLog(value="\u83b7\u53d6\u7528\u6237\u6269\u5c55\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6269\u5c55\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/getUserInfo"})
    @PermissionSource(code="userManage", name="\u7528\u6237\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<UserInfo> getUserInfo(@RequestParam @ApiParam Long userId) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.userInfoService.getUserInfo(userId));
    }

    @UserLog(value="\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u6269\u5c55\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/saveExtUser"})
    @PermissionSource(code="userManage", name="\u7f16\u8f91\u7528\u6237", permType=PermissionType.BUTTON)
    public ReturnVO<Void> saveExtUser(@RequestBody @ApiParam UserInfo userInfo) {
        if (userInfo.getId() != null) {
            this.userInfoService.updateById((Object)userInfo);
        } else {
            this.userInfoService.save((Object)userInfo);
        }
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

