/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.inzyme.spatiotemporal.common.domain.entity.Role;
import com.inzyme.spatiotemporal.common.domain.entity.RoleMenu;
import com.inzyme.spatiotemporal.common.domain.vo.RoleVO;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import com.inzyme.spatiotemporal.web.service.system.IRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/admin/role"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
public class RoleController {
    @Autowired
    IRoleService roleService;

    @UserLog(value="\u89d2\u8272\u5217\u8868")
    @ApiOperation(value="\u89d2\u8272\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="roleManage", name="\u89d2\u8272\u5206\u9875\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<Role>> page(@RequestBody @ApiParam RoleVO roleVO) {
        IPage rolePage = this.roleService.pageRole(roleVO);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)rolePage);
    }

    @UserLog(value="\u5f97\u5230\u89d2\u8272\u7684\u6743\u9650\u6811\u5f62\u5217\u8868")
    @ApiOperation(value="\u5f97\u5230\u89d2\u8272\u7684\u6743\u9650\u6811\u5f62\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/getPermissionList"})
    public ReturnVO<List<RoleMenu>> getPermissionList(@RequestParam @ApiParam(value="\u89d2\u8272ID") Long id) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.roleService.getMenuIdListByRoleId(id));
    }

    @UserLog(value="\u5206\u914d\u89d2\u8272\u6743\u9650")
    @ApiOperation(value="\u5206\u914d\u89d2\u8272\u6743\u9650", notes="\u65e0")
    @PostMapping(value={"/savePermission"})
    @PermissionSource(code="roleManage", name="\u5206\u914d\u89d2\u8272\u6743\u9650", permType=PermissionType.BUTTON)
    public ReturnVO<Void> savePermission(@RequestBody @ApiParam RoleVO roleVO) {
        this.roleService.saveRolePermission(roleVO);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u65b0\u589e\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/addRole"})
    @PermissionSource(code="roleManage", name="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addRole(@RequestBody Role role) {
        this.roleService.insertRole(role);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/updateRole"})
    @PermissionSource(code="roleManage", name="\u7f16\u8f91\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateRole(@RequestBody Role role) {
        this.roleService.updateRole(role);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u5220\u9664\u89d2\u8272\u4fe1\u606f")
    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u4fe1\u606f", notes="\u65e0")
    @PostMapping(value={"/deleteRole"})
    @PermissionSource(code="roleManage", name="\u5220\u9664\u89d2\u8272\u4fe1\u606f", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteRole(@RequestParam @ApiParam(value="\u89d2\u8272ID") Long roleId) {
        this.roleService.deleteRole(roleId);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }
}

