/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.inzyme.spatiotemporal.common.domain.entity.Org;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import com.inzyme.spatiotemporal.web.service.system.IOrgService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/admin/org"})
@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u7ba1\u7406"})
public class OrgController {
    @Autowired
    private IOrgService orgService;

    @UserLog(value="\u67e5\u8be2\u673a\u6784\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u673a\u6784\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/get"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<Org> getOrg(@RequestParam @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") Long id) {
        return new ReturnVO(ReturnEnum.SUCCESS, this.orgService.getById((Serializable)id));
    }

    @UserLog(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/add"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u65b0\u589e\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addOrg(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784") Org org) {
        if (this.orgService.queryRepetition(org).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        this.orgService.addOrg(org);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/update"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u7f16\u8f91\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateOrg(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784") Org org) {
        if (this.orgService.queryRepetition(org).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u673a\u6784\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        this.orgService.updateById((Object)org);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @Transactional
    @PermissionSource(code="orgManage", name="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteOrg(@RequestBody @ApiParam(value="\u7ec4\u7ec7\u673a\u6784ID") List<Long> ids) {
        this.orgService.removeByIds(ids);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u67e5\u8be2\u673a\u6784\u76ee\u5f55\u6811")
    @ApiOperation(value="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Org>> queryTrees(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784ID") Long parentId) {
        List trees = this.orgService.queryTrees(parentId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784")
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u7ec4\u7ec7\u673a\u6784", notes="\u65e0")
    @PostMapping(value={"/subOrgs"})
    @PermissionSource(code="orgManage", name="\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Org>> querySubOrgs(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u7ec4\u7ec7\u673a\u6784ID") Long parentId) {
        List list = this.orgService.querySubOrgs(parentId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)list);
    }
}

