/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.inzyme.spatiotemporal.common.domain.entity.Menu;
import com.inzyme.spatiotemporal.common.domain.vo.LoginVO;
import com.inzyme.spatiotemporal.common.domain.vo.SimpleUserVO;
import com.inzyme.spatiotemporal.core.redis.RedisDao;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.utils.JwtTokenUtils;
import com.inzyme.spatiotemporal.web.core.utils.TreeUtils;
import com.inzyme.spatiotemporal.web.service.system.ILoginService;
import com.inzyme.spatiotemporal.web.service.system.IMenuService;
import com.inzyme.spatiotemporal.web.service.system.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@RequestMapping(value={"/admin/sso"})
@Api(tags={"\u7cfb\u7edf\u767b\u5f55\u5904\u7406"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ILoginService loginService;
    @Autowired
    private IMenuService menuService;
    @Autowired
    private RedisDao redisDao;
    @Autowired
    private IUserService userService;

    @UserLog(value="\u7cfb\u7edf\u767b\u5f55")
    @ApiOperation(value="\u7cfb\u7edf\u767b\u5f55", notes="\u65e0")
    @PostMapping(value={"/login"})
    public ReturnVO<Map<String, Object>> login(@RequestBody @ApiParam LoginVO loginVO) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.loginService.login(loginVO);
        SimpleUserVO userVO = new SimpleUserVO();
        BeanUtils.copyProperties((Object)user, (Object)userVO);
        userVO.setUserId(user.getId());
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("userId", user.getId());
        claims.put("username", user.getUsername());
        String jwtToken = JwtTokenUtils.generateToken((String)user.getUsername(), (int)3600, claims);
        log.debug(jwtToken);
        QueryWrapper menuQuery = new QueryWrapper();
        ((QueryWrapper)menuQuery.eq((Object)"is_deleted", (Object)0)).orderByAsc((Object)"parent_id", (Object[])new String[]{"order_no"});
        List menus = this.menuService.list((Wrapper)menuQuery);
        menus = TreeUtils.list2Tree((List)menus);
        menus = LoginController.hiddenMenus((List)menus);
        map.put("token", jwtToken);
        map.put("roles", user.getRoles());
        map.put("authorities", user.getPermissions());
        map.put("user", userVO);
        map.put("menus", menus);
        AuthorityUtils.putCurrentUser((String)jwtToken, (UserDetails)user);
        return new ReturnVO(ReturnEnum.SUCCESS, map);
    }

    @UserLog(value="\u7cfb\u7edf\u767b\u5f55")
    @ApiOperation(value="\u7cfb\u7edf\u767b\u5f55", notes="\u65e0")
    @PostMapping(value={"/casLogin"})
    public ReturnVO<Map<String, Object>> casLogin(@RequestParam(value="token") String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        User user = this.loginService.casLogin(token);
        if (user == null) {
            new ReturnVO(ReturnEnum.FAILED.getCode(), "\u7528\u6237\u5355\u70b9\u767b\u5f55\u5931\u8d25");
        }
        SimpleUserVO userVO = new SimpleUserVO();
        BeanUtils.copyProperties((Object)user, (Object)userVO);
        userVO.setUserId(user.getId());
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("userId", user.getId());
        claims.put("username", user.getUsername());
        String jwtToken = JwtTokenUtils.generateToken((String)user.getUsername(), (int)3600, claims);
        log.debug(jwtToken);
        QueryWrapper menuQuery = new QueryWrapper();
        ((QueryWrapper)menuQuery.eq((Object)"is_deleted", (Object)0)).orderByAsc((Object)"parent_id", (Object[])new String[]{"order_no"});
        List menus = this.menuService.list((Wrapper)menuQuery);
        menus = TreeUtils.list2Tree((List)menus);
        menus = LoginController.hiddenMenus((List)menus);
        map.put("token", jwtToken);
        map.put("roles", user.getRoles());
        map.put("authorities", user.getPermissions());
        map.put("user", userVO);
        map.put("menus", menus);
        this.redisDao.put("spatiotemporal:cas:token:" + user.getAccessToken(), (Object)user);
        AuthorityUtils.putCurrentUser((String)jwtToken, (UserDetails)user);
        return new ReturnVO(ReturnEnum.SUCCESS, map);
    }

    private static List<Menu> hiddenMenus(List<Menu> menus) {
        Iterator<Menu> it = menus.iterator();
        while (it.hasNext()) {
            Menu menu = it.next();
            if (1 == menu.getHidden()) {
                it.remove();
                continue;
            }
            List children = menu.getChildren();
            if (children == null) continue;
            children = LoginController.hiddenMenus((List)children);
            menu.setChildren(children);
        }
        return menus;
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u7cfb\u7edf\u83dc\u5355", notes="\u65e0")
    @PostMapping(value={"/menus"})
    public ReturnVO<List<Menu>> getMenus() {
        List menu = this.menuService.list(null);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)TreeUtils.list2Tree((List)menu));
    }

    @UserLog(value="\u7cfb\u7edf\u767b\u51fa")
    @GetMapping(value={"/logout"})
    @ApiOperation(value="\u767b\u51fa", notes="\u9000\u51fa\u767b\u9646")
    public ReturnVO<Void> logout(HttpServletRequest request) {
        String token = request.getHeader("X-Token");
        String username = request.getParameter("user");
        if (token != null) {
            this.loginService.logout(token);
            return new ReturnVO(ReturnEnum.SUCCESS);
        }
        if (StringUtils.isNotBlank((String)username)) {
            String tokenStr = this.redisDao.getString("spatiotemporal:username:" + username);
            if (tokenStr != null) {
                this.loginService.logout(tokenStr);
                return new ReturnVO("801", "\u767b\u51fa\u5904\u7406\u6210\u529f");
            }
            return new ReturnVO("802", "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return new ReturnVO(ReturnEnum.FAILED);
    }

    @UserLog(value="\u5355\u70b9\u767b\u5f55\u7528\u6237\u6570\u636e\u540c\u6b65")
    @GetMapping(value={"/casUserSync"})
    @ApiOperation(value="\u5355\u70b9\u767b\u5f55\u7528\u6237\u6570\u636e\u540c\u6b65", notes="\u5355\u70b9\u767b\u5f55\u7528\u6237\u6570\u636e\u540c\u6b65")
    public ReturnVO<Void> casUserSync(HttpServletRequest request) {
        String casToken = request.getParameter("access_token");
        this.userService.userSyncToCenter(casToken);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u5355\u70b9\u767b\u5f55\u7528\u6237\u63a8\u9001")
    @PostMapping(value={"/ssoUser"})
    @ApiOperation(value="\u7528\u6237\u63a8\u9001", notes="\u7528\u6237\u63a8\u9001")
    public ReturnVO<Void> ssoUser(@RequestParam(value="token") String token, String username, String password) {
        return this.userService.ssoUser(token, username, password);
    }
}

