/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.inzyme.spatiotemporal.common.domain.entity.Dict;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import com.inzyme.spatiotemporal.web.service.system.IDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/admin/dict"})
@Api(tags={"\u6570\u636e\u5b57\u5178\u7ba1\u7406"})
public class DictController {
    @Autowired
    private IDictService dictService;

    @UserLog(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811")
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="dictManage", name="\u6570\u636e\u5b57\u5178\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Dict>> queryTrees(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u6570\u636e\u5b57\u5178ID") Long parentId) {
        List trees = this.dictService.queryTrees(parentId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @UserLog(value="\u65b0\u589e\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/add"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u65b0\u589e\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> addDict(@RequestBody @ApiParam(value="\u6570\u636e\u5b57\u5178") Dict dict) {
        if (this.dictService.queryRepetition(dict).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u5b57\u5178\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        this.dictService.addDict(dict);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u66f4\u65b0\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/update"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u7f16\u8f91\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> updateDict(@RequestBody @ApiParam(value="\u6570\u636e\u5b57\u5178") Dict dict) {
        if (this.dictService.queryRepetition(dict).booleanValue()) {
            return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u5df2\u6709\u76f8\u540c\u5b57\u5178\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0");
        }
        this.dictService.updateDict(dict);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/get"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u6570\u636e\u5b57\u5178\u67e5\u8be2", permType=PermissionType.BUTTON)
    public ReturnVO<Dict> getDict(@RequestParam @ApiParam(value="\u6570\u636e\u5b57\u5178ID") Long id) {
        return new ReturnVO(ReturnEnum.SUCCESS, this.dictService.getById((Serializable)id));
    }

    @UserLog(value="\u5220\u9664\u6570\u636e\u5b57\u5178")
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5b57\u5178", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @Transactional
    @PermissionSource(code="dictManage", name="\u5220\u9664\u6570\u636e\u5b57\u5178", permType=PermissionType.BUTTON)
    public ReturnVO<Void> deleteDict(@RequestParam @ApiParam(value="\u6570\u636e\u5b57\u5178ID") Long id) {
        this.dictService.removeById((Serializable)id);
        return new ReturnVO(ReturnEnum.SUCCESS);
    }

    @UserLog(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879")
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879", notes="\u65e0")
    @PostMapping(value={"/getDictItems"})
    public ReturnVO<?> getDictItemsByDictType(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u5b57\u5178\u5206\u7c7bCODE") String code) {
        Map dictItems = this.dictService.getDictItemsByDictType(code);
        if (dictItems != null) {
            return new ReturnVO(ReturnEnum.SUCCESS, (Object)dictItems);
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u65e0\u6548\u7684\u5b57\u5178\u5206\u7c7b");
    }

    @UserLog(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879")
    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u5206\u7c7bCODE,\u83b7\u53d6\u5b57\u5178\u5206\u7c7b\u4e0b\u7684\u6240\u6709\u5b57\u5178\u9879", notes="\u65e0")
    @PostMapping(value={"/getDictItemLabel"})
    public ReturnVO<?> getDictItemLabel(@RequestParam(value="code") @ApiParam(value="\u6570\u636e\u5b57\u5178\u5206\u7c7bCODE") String code, @RequestParam(value="value") @ApiParam(value="\u6570\u636e\u5b57\u5178\u9879VALUE") String value) {
        Map dictItems = this.dictService.getDictItemsByDictType(code);
        if (dictItems != null) {
            if (dictItems.get(value) == null) {
                return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u65e0\u6548\u7684\u5b57\u5178\u9879");
            }
            return new ReturnVO(ReturnEnum.SUCCESS, dictItems.get(value));
        }
        return new ReturnVO(ReturnEnum.FAILED.getCode(), "\u65e0\u6548\u7684\u5b57\u5178\u5206\u7c7b");
    }
}

