/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.inzyme.spatiotemporal.common.domain.entity.Area;
import com.inzyme.spatiotemporal.common.domain.vo.AreaVO;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.constants.enums.PermissionType;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.inzyme.spatiotemporal.web.core.permission.PermissionSource;
import com.inzyme.spatiotemporal.web.service.system.IAreaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/admin/area"})
@Api(tags={"\u533a\u57df\u7ba1\u7406"})
public class AreaController {
    @Autowired
    private IAreaService areaService;

    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u76ee\u5f55\u6811", notes="\u65e0")
    @PostMapping(value={"/trees"})
    @PermissionSource(code="areaManage", name="\u533a\u57df\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Area>> queryTrees(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u533a\u57dfID") Long parentId) {
        List trees = this.areaService.queryTrees(parentId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)trees);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u7ea7\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/subAreas"})
    @PermissionSource(code="areaManage", name="\u533a\u57df\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<List<Area>> querySubAreas(@RequestParam(required=false) @ApiParam(value="\u4e0a\u7ea7\u533a\u57dfID") Long parentId) {
        List list = this.areaService.querySubAreas(parentId);
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)list);
    }

    @ApiOperation(value="\u533a\u57df\u5217\u8868", notes="\u65e0")
    @PostMapping(value={"/page"})
    @PermissionSource(code="areaManage", name="\u533a\u57df\u5217\u8868\u67e5\u8be2", permType=PermissionType.MENU)
    public ReturnVO<IPage<Area>> page(@RequestBody @ApiParam AreaVO areaVO) {
        return new ReturnVO(ReturnEnum.SUCCESS, (Object)this.areaService.page(areaVO));
    }

    @ApiOperation(value="\u65b0\u589e\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/add"})
    @PermissionSource(code="areaManage", name="\u65b0\u589e\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> add(@RequestBody @ApiParam Area area) {
        return this.areaService.addArea(area);
    }

    @UserLog(value="\u533a\u57df\u8be6\u60c5")
    @ApiOperation(value="\u533a\u57df\u8be6\u60c5", notes="\u65e0")
    @PostMapping(value={"/getArea"})
    @PermissionSource(code="areaManage", name="\u7f16\u8f91\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Area> getAreaById(@RequestParam(value="areaId") @ApiParam Long areaId) {
        return this.areaService.getAreaById(areaId);
    }

    @UserLog(value="\u66f4\u65b0\u533a\u57df")
    @ApiOperation(value="\u66f4\u65b0\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/update"})
    @PermissionSource(code="areaManage", name="\u7f16\u8f91\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> update(@RequestBody @ApiParam Area area) {
        return this.areaService.updateArea(area);
    }

    @UserLog(value="\u5220\u9664\u533a\u57df")
    @ApiOperation(value="\u5220\u9664\u533a\u57df", notes="\u65e0")
    @PostMapping(value={"/delete"})
    @PermissionSource(code="areaManage", name="\u5220\u9664\u533a\u57df", permType=PermissionType.BUTTON)
    public ReturnVO<Boolean> delete(@RequestParam(value="areaId") @ApiParam Long areaId) {
        return this.areaService.deleteArea(areaId);
    }
}

