/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.web;

import com.inzy.common.config.EnableServerRegister;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableTransactionManagement
@SpringBootApplication(scanBasePackages={"com.inzyme.spatiotemporal.core,com.inzyme.spatiotemporal.web.core,com.inzyme.spatiotemporal.common.properties,com.inzyme.spatiotemporal.common.utils,com.inzyme.spatiotemporal.common.aspect,com.inzyme.spatiotemporal.common.exception,com.inzyme.spatiotemporal.web.*"})
@MapperScan(value={"com.inzyme.spatiotemporal.web.core.dao,com.inzyme.spatiotemporal.common.dao.web"})
@EnableServerRegister(autoRegister=true, period=60)
@ServletComponentScan
public class RoadMonitorAdminApplication {
    private static final Logger log = LoggerFactory.getLogger(RoadMonitorAdminApplication.class);

    public static void main(String[] args) {
        try {
            SpringApplication app = new SpringApplication(new Class[]{RoadMonitorAdminApplication.class});
            ConfigurableApplicationContext context = app.run(args);
            String serverPort = context.getEnvironment().getProperty("server.port");
            String cp = context.getEnvironment().getProperty("server.servlet.context-path");
            log.info("\u542f\u52a8\u6210\u529f! Swagger2: http://127.0.0.1:" + serverPort + cp + "/swagger-ui.html");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

