/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.PriorityQueue;
import java.util.TimeZone;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatUtils {
    private static final Logger log = LoggerFactory.getLogger(StatUtils.class);

    public static String timestampToDateFormat(Long timestampStr, String dateFormat, Integer offsetFormat) {
        timestampStr = StatUtils.timestampConvert(timestampStr);
        Date date = null;
        try {
            date = new Date(timestampStr);
        }
        catch (Exception e) {
            log.info("##### \u65f6\u95f4\u8f6c\u6362\u5931\u8d25 cause : " + e);
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(10, calendar.get(10) + offsetFormat);
        Date newDate = calendar.getTime();
        return sdf.format(newDate);
    }

    public static String timestampToDateFormat(Long timestampStr, String dateFormat) {
        return StatUtils.timestampToDateFormat(timestampStr, dateFormat, 8);
    }

    private static Long timestampConvert(Long timestamp) {
        String string = timestamp.toString();
        switch (string.length()) {
            case 10: {
                timestamp = timestamp * 1000L;
                break;
            }
            case 16: {
                timestamp = timestamp / 1000L;
                break;
            }
            case 19: {
                timestamp = timestamp / 1000L / 1000L;
            }
        }
        return timestamp;
    }

    public static String nvl(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static int toInt(Object obj) {
        Integer rtn = 0;
        try {
            if (null != obj) {
                rtn = Integer.valueOf(obj.toString());
            }
        }
        catch (Exception ex) {
            rtn = 0;
        }
        return rtn;
    }

    public static double toDouble(Object obj) {
        double rtn = 0.0;
        try {
            if (null != obj) {
                rtn = Double.valueOf(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static long toLong(Object str) {
        Long rtn = 0L;
        try {
            rtn = Long.valueOf(str.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static Float toFloat(Object str) {
        Float rtn = Float.valueOf(0.0f);
        try {
            rtn = Float.valueOf(str.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static boolean comparisonHour(long time) {
        return System.currentTimeMillis() - StatUtils.timestampConvert(time) < 3600000L;
    }

    public static List<String> getDateString(Integer num) {
        String today = StatUtils.timestampToDateFormat(System.currentTimeMillis(), "yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> putDates = new ArrayList<String>();
        try {
            if (num <= 0) {
                return putDates;
            }
            for (int i = 0; i < num; ++i) {
                Date date = sdf.parse(today);
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                ((Calendar)calendar).add(5, -i);
                date = calendar.getTime();
                String putDate = sdf.format(date);
                putDates.add(putDate);
            }
            return putDates;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return putDates;
        }
    }

    public static List partitionList(List list, int pageNum, int pageSize) {
        List pageList;
        if (list.isEmpty()) {
            return list;
        }
        if (pageNum <= 1) {
            pageNum = 1;
        }
        if ((pageList = ListUtils.partition((List)list, (int)pageSize)).size() <= pageNum - 1) {
            pageNum = pageList.size();
        }
        return (List)pageList.get(pageNum - 1);
    }

    public static String dateToStr(Date d, String type) {
        SimpleDateFormat sdf = new SimpleDateFormat(type);
        String dateNowStr = sdf.format(d);
        return dateNowStr;
    }

    public static Integer compareInt(Object a, Object b) {
        if (StatUtils.toInt(a) >= StatUtils.toInt(b)) {
            return StatUtils.toInt(a);
        }
        return StatUtils.toInt(b);
    }

    public static Float compareFloat(Object a, Object b) {
        if (StatUtils.toFloat(a).floatValue() >= StatUtils.toFloat(b).floatValue()) {
            return StatUtils.toFloat(a);
        }
        return StatUtils.toFloat(b);
    }

    public static List<String> gethours() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        ArrayList<String> hours = new ArrayList<String>();
        for (int i = hour; i >= 0; --i) {
            hours.add(String.valueOf(StatUtils.toInt(StatUtils.dateToStr(new Date(), "yyyyMMddHH")) - i));
        }
        return hours;
    }

    public static List<String> getMins() {
        ArrayList<String> minites = new ArrayList<String>();
        long end = StatUtils.toLong(StatUtils.dateToStr(new Date(), "yyyyMMddHHmm"));
        for (long start = StatUtils.toLong(StatUtils.dateToStr(new Date(), "yyyyMMddHH")) * 100L; start <= end; ++start) {
            minites.add(String.valueOf(start));
        }
        return minites;
    }

    public static Float getMedianNum(Float[] arr) {
        int i;
        if (arr == null || arr.length == 0) {
            return null;
        }
        if (arr.length == 1) {
            return arr[0];
        }
        PriorityQueue<Float> minPQ = new PriorityQueue<Float>();
        int length = arr.length;
        int k = length / 2 + 1;
        for (i = 0; i < k; ++i) {
            minPQ.add(arr[i]);
        }
        for (i = k; i < length; ++i) {
            if (!(((Float)minPQ.peek()).floatValue() < arr[i].floatValue())) continue;
            minPQ.poll();
            minPQ.add(arr[i]);
        }
        if (length % 2 == 0) {
            return Float.valueOf((((Float)minPQ.poll()).floatValue() + ((Float)minPQ.peek()).floatValue()) / 2.0f);
        }
        return Float.valueOf(((Float)minPQ.peek()).floatValue());
    }

    public static void main(String[] args) {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(10, -23);
        System.out.println(StatUtils.dateToStr(calendar2.getTime(), "yyyyMMddHH"));
    }
}

