/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.inzyme.spatiotemporal.common.utils.ResultCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="\u516c\u5171\u8fd4\u56de\u6a21\u7248")
public class ResponseDto<T> {
    @ApiModelProperty(value="\u72b6\u6001\u7801")
    private Long status;
    @ApiModelProperty(value="\u6d88\u606f")
    private String message;
    @ApiModelProperty(value="\u6570\u636e\u5bf9\u8c61")
    private T object;

    public static ResponseDto success() {
        return new ResponseDto<Object>(ResultCode.SUCCESS.getCode(), ResultCode.SUCCESS.getMessage(), null);
    }

    public static <T> ResponseDto<T> success(T data) {
        return new ResponseDto<T>(ResultCode.SUCCESS.getCode(), ResultCode.SUCCESS.getMessage(), data);
    }

    public static <T> ResponseDto<T> success(String message, T data) {
        return new ResponseDto<T>(ResultCode.SUCCESS.getCode(), message, data);
    }

    public static <T> ResponseDto<T> failed(ResultCode errorCode) {
        return new ResponseDto<Object>(errorCode.getCode(), errorCode.getMessage(), null);
    }

    public static <T> ResponseDto<T> failed(String message) {
        return new ResponseDto<Object>(ResultCode.FAILED.getCode(), message, null);
    }

    public static <T> ResponseDto<T> failed() {
        return ResponseDto.failed(ResultCode.FAILED);
    }

    public static <T> ResponseDto<T> validateFailed() {
        return ResponseDto.failed(ResultCode.VALIDATE_FAILED);
    }

    public static <T> ResponseDto<T> validateFailed(String message) {
        return new ResponseDto<Object>(ResultCode.VALIDATE_FAILED.getCode(), message, null);
    }

    public static <T> ResponseDto<T> unauthorized(T data) {
        return new ResponseDto<T>(ResultCode.UNAUTHORIZED.getCode(), ResultCode.UNAUTHORIZED.getMessage(), data);
    }

    public static <T> ResponseDto<T> forbidden(T data) {
        return new ResponseDto<T>(ResultCode.FORBIDDEN.getCode(), ResultCode.FORBIDDEN.getMessage(), data);
    }

    public Long getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public T getObject() {
        return this.object;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseDto)) {
            return false;
        }
        ResponseDto other = (ResponseDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$status = this.getStatus();
        Long other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$object = this.getObject();
        T other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseDto(status=" + this.getStatus() + ", message=" + this.getMessage() + ", object=" + this.getObject() + ")";
    }

    public ResponseDto(Long status, String message, T object) {
        this.status = status;
        this.message = message;
        this.object = object;
    }

    public ResponseDto() {
    }
}

