/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            log.error("expire() is error : {}", (Throwable)e);
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            log.error("hasKey() is error : {}", (Throwable)e);
            return false;
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("set() is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            log.error("set() is error : {}", (Throwable)e);
            return false;
        }
    }

    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<Object, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error("hmset1 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("hmset22 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            log.error("hset() is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("hset() is error : {}", (Throwable)e);
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("sGet() is error : {}", (Throwable)e);
            return new HashSet<Object>();
        }
    }

    public Set<Object> sGetByChangeSerializer(String key) {
        try {
            StringRedisSerializer stringSerializer = new StringRedisSerializer();
            this.redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
            this.redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
            this.redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
            this.redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("sGet() is error : {}", (Throwable)e);
            return new HashSet<Object>();
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error("sHasKey() is error : {}", (Throwable)e);
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error("sSet() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            log.error("sSetAndTime() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error("sGetSetSize() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            log.error("setRemove() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error("lGet() is error : {}", (Throwable)e);
            return new ArrayList<Object>();
        }
    }

    public List<Object> lGet(String key) {
        return this.lGet(key, 0L, -1L);
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error("lGetListSize() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error("lGetIndex() is error : {}", (Throwable)e);
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("lSet1 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("lSet2 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error("lSet3 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            log.error("lSet()4 is error : {}", (Throwable)e);
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error("lUpdateIndex() is error : {}", (Throwable)e);
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            return this.redisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            log.error("lRemove() is error : {}", (Throwable)e);
            return 0L;
        }
    }

    public <T> T getObjectBean(String key, Class<T> clazz) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        return this.parseJson(value, clazz);
    }

    public <T> void setObjectBean(String key, T obj) {
        if (obj == null) {
            return;
        }
        String value = this.toJson(obj);
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public <T> T getAndSet(String key, T obj, Class<T> clazz) {
        if (obj == null) {
            return this.getObjectBean(key, clazz);
        }
        String value = (String)this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)this.toJson(obj));
        return this.parseJson(value, clazz);
    }

    public long generate(String key) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        return counter.incrementAndGet();
    }

    public long generate(String key, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.incrementAndGet();
    }

    public long generate(String key, int increment) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        return counter.addAndGet((long)increment);
    }

    public long generate(String key, int increment, Date expireTime) {
        RedisAtomicLong counter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        counter.expireAt(expireTime);
        return counter.addAndGet((long)increment);
    }

    public String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField});
    }

    public <T> T parseJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        try {
            Object cache = this.get(key);
            if (null != cache && StringUtils.isNotBlank((CharSequence)cache.toString())) {
                return JSON.parseArray((String)JSON.parseArray((String)cache.toString()).toJSONString(), clazz);
            }
        }
        catch (Exception e) {
            log.error("redis\u67e5\u8be2\u5f02\u5e38\uff0ce:", (Throwable)e);
        }
        return new ArrayList();
    }
}

