/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(PojoConvertUtil.class);
    private static final Map<String, Map<String, Field>> CACHE_FIELDS = new ConcurrentHashMap<String, Map<String, Field>>();
    private static final Set<Class> BASIC_CLASS = new HashSet<Class>();

    public static <T> T convertPojo(Object orig, Class<T> targetClass) {
        try {
            T target = targetClass.newInstance();
            Field[] fields = orig.getClass().getDeclaredFields();
            Field[] fieldSupers = orig.getClass().getSuperclass().getDeclaredFields();
            int str1Length = fields.length;
            int str2length = fieldSupers.length;
            fields = Arrays.copyOf(fields, str1Length + str2length);
            System.arraycopy(fieldSupers, 0, fields, str1Length, str2length);
            for (Field field : fields) {
                Object value;
                Field targetField;
                if (PojoConvertUtil.isStatic(field) || (targetField = PojoConvertUtil.getTargetField(targetClass, field.getName())) == null || (value = PojoConvertUtil.getFiledValue(field, orig)) == null) continue;
                Class<?> type1 = field.getType();
                Class<?> type2 = targetField.getType();
                boolean sameType = type1.equals(type2);
                if (PojoConvertUtil.isBasicType(type1)) {
                    if (!sameType) continue;
                    PojoConvertUtil.setFieldValue(targetField, target, value);
                    continue;
                }
                if (value instanceof Map && Map.class.isAssignableFrom(type2)) {
                    PojoConvertUtil.setMap((Map)value, field, targetField, target);
                    continue;
                }
                if (value instanceof Set && Set.class.isAssignableFrom(type2)) {
                    PojoConvertUtil.setCollection((Collection)value, field, targetField, target);
                    continue;
                }
                if (value instanceof List && List.class.isAssignableFrom(type2)) {
                    PojoConvertUtil.setCollection((Collection)value, field, targetField, target);
                    continue;
                }
                if (value instanceof Enum && Enum.class.isAssignableFrom(type2)) {
                    PojoConvertUtil.setEnum((Enum)value, field, targetField, target);
                    continue;
                }
                if (!(value instanceof java.util.Date) || !java.util.Date.class.isAssignableFrom(type2)) continue;
                PojoConvertUtil.setDate((java.util.Date)value, targetField, type2, target, sameType);
            }
            return target;
        }
        catch (Throwable t) {
            log.error("\u8f6c\u6362\u5931\u8d25:" + t.getMessage());
            throw new RuntimeException(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFiledValue(Field field, Object obj) throws IllegalAccessException {
        boolean access = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(obj);
            return object;
        }
        finally {
            field.setAccessible(access);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setFieldValue(Field field, Object obj, Object value) throws IllegalAccessException {
        boolean access = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        finally {
            field.setAccessible(access);
        }
    }

    public static <T> List<T> convertPojos(List orig, Class<T> targetClass) {
        ArrayList<T> list = new ArrayList<T>(orig.size());
        for (Object object : orig) {
            list.add(PojoConvertUtil.convertPojo(object, targetClass));
        }
        return list;
    }

    public static <T> IPage<T> convertPojos(IPage orig, Class<T> targetClass) {
        Page returnResult = new Page();
        ArrayList<T> list = new ArrayList<T>(orig.getRecords().size());
        for (Object object : orig.getRecords()) {
            list.add(PojoConvertUtil.convertPojo(object, targetClass));
        }
        returnResult.setTotal(orig.getTotal());
        returnResult.setRecords(list);
        return returnResult;
    }

    private static <T> void setMap(Map value, Field origField, Field targetField, T targetObject) throws IllegalAccessException, InstantiationException {
        Type origType = origField.getGenericType();
        Type targetType = targetField.getGenericType();
        if (origType instanceof ParameterizedType && targetType instanceof ParameterizedType) {
            Class clazz;
            ParameterizedType origParameterizedType = (ParameterizedType)origType;
            Type[] origTypes = origParameterizedType.getActualTypeArguments();
            ParameterizedType targetParameterizedType = (ParameterizedType)targetType;
            Type[] targetTypes = targetParameterizedType.getActualTypeArguments();
            if (origTypes != null && origTypes.length == 2 && targetTypes != null && targetTypes.length == 2 && !PojoConvertUtil.isBasicType(clazz = (Class)origTypes[1]) && !clazz.equals(targetTypes[1])) {
                Set entries = value.entrySet();
                Map targetMap = (Map)value.getClass().newInstance();
                for (Map.Entry entry : entries) {
                    targetMap.put(entry.getKey(), PojoConvertUtil.convertPojo(entry.getValue(), (Class)targetTypes[1]));
                }
                PojoConvertUtil.setFieldValue(targetField, targetObject, targetMap);
                return;
            }
        }
        PojoConvertUtil.setFieldValue(targetField, targetObject, value);
    }

    private static <T> void setCollection(Collection value, Field origField, Field targetField, T targetObject) throws IllegalAccessException, InstantiationException {
        Type origType = origField.getGenericType();
        Type targetType = targetField.getGenericType();
        if (origType instanceof ParameterizedType && targetType instanceof ParameterizedType) {
            Class clazz;
            ParameterizedType origParameterizedType = (ParameterizedType)origType;
            Type[] origTypes = origParameterizedType.getActualTypeArguments();
            ParameterizedType targetParameterizedType = (ParameterizedType)targetType;
            Type[] targetTypes = targetParameterizedType.getActualTypeArguments();
            if (origTypes != null && origTypes.length == 1 && targetTypes != null && targetTypes.length == 1 && !PojoConvertUtil.isBasicType(clazz = (Class)origTypes[0]) && !clazz.equals(targetTypes[0])) {
                Collection collection = (Collection)value.getClass().newInstance();
                for (Object obj : value) {
                    collection.add(PojoConvertUtil.convertPojo(obj, (Class)targetTypes[0]));
                }
                PojoConvertUtil.setFieldValue(targetField, targetObject, collection);
                return;
            }
        }
        PojoConvertUtil.setFieldValue(targetField, targetObject, value);
    }

    private static <T> void setEnum(Enum value, Field origField, Field targetField, T targetObject) throws Exception {
        if (origField.equals(targetField)) {
            PojoConvertUtil.setFieldValue(targetField, targetObject, value);
        } else {
            Method method = targetField.getType().getMethod("valueOf", String.class);
            PojoConvertUtil.setFieldValue(targetField, targetObject, method.invoke(null, value.toString()));
        }
    }

    private static <T> void setDate(java.util.Date value, Field targetField, Class targetFieldType, T targetObject, boolean sameType) throws IllegalAccessException {
        java.util.Date date = null;
        if (sameType) {
            date = value;
        } else if (targetFieldType.equals(Date.class)) {
            date = new Date(value.getTime());
        } else if (targetFieldType.equals(java.util.Date.class)) {
            date = new java.util.Date(value.getTime());
        } else if (targetFieldType.equals(Timestamp.class)) {
            date = new Timestamp(value.getTime());
        }
        PojoConvertUtil.setFieldValue(targetField, targetObject, date);
    }

    public static Field getTargetField(Class clazz, String fieldName) {
        String classKey = clazz.getName();
        Map<String, Field> fieldMap = CACHE_FIELDS.get(classKey);
        if (fieldMap == null) {
            Field[] fields;
            fieldMap = new HashMap<String, Field>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (PojoConvertUtil.isStatic(field)) continue;
                fieldMap.put(field.getName(), field);
            }
            CACHE_FIELDS.put(classKey, fieldMap);
        }
        return fieldMap.get(fieldName);
    }

    public static boolean isBasicType(Class clazz) {
        return clazz.isPrimitive() || BASIC_CLASS.contains(clazz);
    }

    public static boolean isStatic(Field field) {
        return (8 & field.getModifiers()) == 8;
    }

    static {
        BASIC_CLASS.add(Integer.class);
        BASIC_CLASS.add(Character.class);
        BASIC_CLASS.add(Byte.class);
        BASIC_CLASS.add(Float.class);
        BASIC_CLASS.add(Double.class);
        BASIC_CLASS.add(Boolean.class);
        BASIC_CLASS.add(Long.class);
        BASIC_CLASS.add(Short.class);
        BASIC_CLASS.add(String.class);
        BASIC_CLASS.add(BigDecimal.class);
    }
}

