/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.inzyme.spatiotemporal.common.domain.dto.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MapAreaUtils {
    private static final double EARTH_RADIUS = 6378137.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static boolean isInCircle(double radius, Point p1, Point p2) {
        double radLat1 = MapAreaUtils.rad(p1.getLat());
        double radLat2 = MapAreaUtils.rad(p2.getLat());
        double a = radLat1 - radLat2;
        double b = MapAreaUtils.rad(p1.getLng()) - MapAreaUtils.rad(p2.getLng());
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378137.0;
        return !((s = (double)(Math.round(s * 10000.0) / 10000L)) > radius);
    }

    public static boolean isInRectangleArea(double lng, double lat, double minLng, double maxLng, double minLat, double maxLat) {
        if (MapAreaUtils.isInRange(lat, minLat, maxLat)) {
            if (minLng * maxLng > 0.0) {
                return MapAreaUtils.isInRange(lng, minLng, maxLng);
            }
            if (Math.abs(minLng) + Math.abs(maxLng) < 180.0) {
                return MapAreaUtils.isInRange(lng, minLng, maxLng);
            }
            double left = Math.max(minLng, maxLng);
            double right = Math.min(minLng, maxLng);
            return MapAreaUtils.isInRange(lng, left, 180.0) || MapAreaUtils.isInRange(lng, right, -180.0);
        }
        return false;
    }

    public static boolean isInRectangleArea(Point point, Point[] gpsPoints) {
        if (gpsPoints.length != 4) {
            return false;
        }
        double[] lats = new double[4];
        double[] lngs = new double[4];
        for (int i = 0; i < gpsPoints.length; ++i) {
            lats[i] = gpsPoints[i].getLat();
            lngs[i] = gpsPoints[i].getLng();
        }
        Arrays.sort(lats);
        Arrays.sort(lngs);
        return MapAreaUtils.isInRectangleArea(point.getLat(), point.getLng(), lats[0], lats[3], lngs[0], lngs[3]);
    }

    public static boolean isInRange(double point, double left, double right) {
        return point >= Math.min(left, right) && point <= Math.max(left, right);
    }

    public static boolean isInPolygon(Point point, List<Point> pts) {
        int N = pts.size();
        boolean boundOrVertex = true;
        int intersectCount = 0;
        double precision = 2.0E-10;
        Point p = point;
        Point p1 = pts.get(0);
        for (int i = 1; i <= N; ++i) {
            if (p.equals(p1)) {
                return boundOrVertex;
            }
            Point p2 = pts.get(i % N);
            if (p.getLng() < Math.min(p1.getLng(), p2.getLng()) || p.getLng() > Math.max(p1.getLng(), p2.getLng())) {
                p1 = p2;
                continue;
            }
            if (p.getLng() > Math.min(p1.getLng(), p2.getLng()) && p.getLng() < Math.max(p1.getLng(), p2.getLng())) {
                if (p.getLat() <= Math.max(p1.getLat(), p2.getLat())) {
                    if (p1.getLng() == p2.getLng() && p.getLat() >= Math.min(p1.getLat(), p2.getLat())) {
                        return boundOrVertex;
                    }
                    if (p1.getLat() == p2.getLat()) {
                        if (p1.getLat() == p.getLat()) {
                            return boundOrVertex;
                        }
                        ++intersectCount;
                    } else {
                        double xinters = (p.getLng() - p1.getLng()) * (p2.getLat() - p1.getLat()) / (p2.getLng() - p1.getLng()) + p1.getLat();
                        if (Math.abs(p.getLat() - xinters) < precision) {
                            return boundOrVertex;
                        }
                        if (p.getLat() < xinters) {
                            ++intersectCount;
                        }
                    }
                }
            } else if (p.getLng() == p2.getLng() && p.getLat() <= p2.getLat()) {
                Point p3 = pts.get((i + 1) % N);
                intersectCount = p.getLng() >= Math.min(p1.getLng(), p3.getLng()) && p.getLng() <= Math.max(p1.getLng(), p3.getLng()) ? ++intersectCount : (intersectCount += 2);
            }
            p1 = p2;
        }
        return intersectCount % 2 != 0;
    }

    public static double pointToSegDist(double x, double y, double x1, double y1, double x2, double y2) {
        double cross = (x2 - x1) * (x - x1) + (y2 - y1) * (y - y1);
        if (cross <= 0.0) {
            return Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1));
        }
        double d2 = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        if (cross >= d2) {
            return Math.sqrt((x - x2) * (x - x2) + (y - y2) * (y - y2));
        }
        double r = cross / d2;
        double px = x1 + (x2 - x1) * r;
        double py = y1 + (y2 - y1) * r;
        return Math.sqrt((x - px) * (x - px) + (py - y1) * (py - y1));
    }

    public static boolean isRouteOffset(List<Point> points, Point locationPoint, double distanceTolerate) {
        Double tolerate = distanceTolerate * 1.0E-5;
        Point leftPoint = null;
        Point rightPoint = null;
        if (null != points && !points.isEmpty()) {
            for (int i = 0; i < points.size() - 1; ++i) {
                leftPoint = points.get(i);
                rightPoint = points.get(i + 1);
                if (Math.abs(locationPoint.getLng() - leftPoint.getLng()) <= tolerate && Math.abs(locationPoint.getLat() - leftPoint.getLat()) < distanceTolerate) {
                    return false;
                }
                if (Math.abs(locationPoint.getLng() - rightPoint.getLng()) <= tolerate && Math.abs(locationPoint.getLat() - rightPoint.getLat()) < distanceTolerate) {
                    return false;
                }
                if (!(MapAreaUtils.pointToSegDist(locationPoint.getLng(), locationPoint.getLat(), leftPoint.getLng(), leftPoint.getLat(), rightPoint.getLng(), rightPoint.getLat()) < tolerate)) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(121.366961, 31.190049));
        points.add(new Point(121.366951, 31.190039));
        points.add(new Point(121.366931, 31.190029));
        System.out.println("\u7ebf\u8def\u504f\u79fb\u4e0e\u5426:" + MapAreaUtils.isRouteOffset(points, new Point(122.366941, 33.345678), 5.0));
    }
}

