/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.inzyme.spatiotemporal.common.utils.BeanUtil;
import com.inzyme.spatiotemporal.common.utils.Token;
import java.security.MessageDigest;
import java.util.Base64;

public class JWTTokenUtil {
    private Long expTime = 1200000L;
    private Long tokeGraTime = this.expTime * 2L;
    private String issuser = "AUTHENTATICTION_CENTER";
    private String audience = "CLIENT";
    private String headType = "JWT";
    private String headALG = "HS256";
    private static final JWTTokenUtil DEFAULT = new JWTTokenUtil();
    private static JWTTokenUtil userDefined = null;

    private JWTTokenUtil() {
    }

    private JWTTokenUtil(Long expTime, Long tokeGraTime, String issuser, String audience, String headType, String headALG) {
        this.expTime = expTime == null ? this.expTime : expTime;
        this.tokeGraTime = tokeGraTime == null ? this.tokeGraTime : tokeGraTime;
        this.issuser = issuser == null ? this.issuser : issuser;
        this.audience = audience == null ? this.audience : audience;
        this.headType = headType == null ? this.headType : headType;
        this.headALG = headALG == null ? this.headALG : headALG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildDefined(Long expTime, Long tokeGraTime, String issuser, String audience, String headType, String headALG) {
        Class<JWTTokenUtil> clazz = JWTTokenUtil.class;
        synchronized (JWTTokenUtil.class) {
            if (userDefined != null) {
                throw new RuntimeException("\u8be5\u65b9\u6cd5\u53ea\u80fd\u521d\u59cb\u5316\u4e00\u6b21");
            }
            userDefined = new JWTTokenUtil(expTime, tokeGraTime, issuser, audience, headType, headALG);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static JWTTokenUtil definedUtil() {
        if (userDefined == null) {
            throw new RuntimeException("\u7528\u6237\u5c1a\u672a\u81ea\u5b9a\u4e49jwt\u4fe1\u606f\uff0c\u8bf7\u8c03\u7528buildDefined()\u65b9\u6cd5\u521d\u59cb\u5316\uff1b");
        }
        return userDefined;
    }

    public static JWTTokenUtil defaultUtil() {
        return DEFAULT;
    }

    public Token create(String secret, String tokenId, String userType, String userInfo) {
        Token token = new Token();
        Token.Head head = new Token.Head();
        head.setAlg(this.headALG);
        head.setTyp(this.headType);
        long iat = System.currentTimeMillis();
        long exp = iat + this.expTime;
        long gra = iat + this.tokeGraTime;
        Token.Playload playload = new Token.Playload();
        playload.setAud(this.audience);
        playload.setIat(iat);
        playload.setExp(exp);
        playload.setGra(gra);
        playload.setIss(this.issuser);
        playload.setJti(tokenId);
        playload.setNbf(iat);
        playload.setSub(userInfo);
        playload.setTyp(userType.toString().toUpperCase());
        String headBase64 = TokenUtil.headToBase64(head);
        String playloadBase64 = TokenUtil.playloadToBase64(playload);
        String signature = TokenUtil.secretToBase64(headBase64, playloadBase64, secret);
        String tokenStr = headBase64 + "." + playloadBase64 + "." + signature;
        token.setHead(head);
        token.setPlayload(playload);
        token.setBase64Head(headBase64);
        token.setBase64PlayLoad(playloadBase64);
        token.setSignature(signature);
        token.setTokenStr(tokenStr);
        return token;
    }

    public Token parse(String token, String secret) {
        String signaturedStr;
        String[] tokens = null;
        if (token == null || secret == null || (tokens = token.split("\\.")) == null || tokens.length != 3) {
            return null;
        }
        String base64Head = tokens[0].trim();
        String base64Playload = tokens[1].trim();
        String signature = tokens[2].trim();
        if (!signature.equals(signaturedStr = TokenUtil.secretToBase64(base64Head, base64Playload, secret.trim()))) {
            return null;
        }
        Token.Head head = TokenUtil.base64ToHead(base64Head);
        Token.Playload playLoad = TokenUtil.base64ToPlayload(base64Playload);
        Token rs = new Token();
        rs.setBase64Head(base64Head);
        rs.setBase64PlayLoad(base64Playload);
        rs.setHead(head);
        rs.setPlayload(playLoad);
        rs.setSignature(signature);
        rs.setTokenStr(token);
        return rs;
    }

    public Token parseAndRefresh(String token, String secret) {
        Token t = this.parse(token, secret);
        return t == null || this.isInvalid(t) ? null : this.refresh(t);
    }

    public boolean isIllegality(String token, String secret) {
        return this.parse(token, secret) == null;
    }

    public boolean isTimeout(String token, String secret) {
        return this.isTimeout(this.parse(token, secret));
    }

    public boolean isTimeout(Token token) {
        Token.Playload pl = token.getPlayload();
        return System.currentTimeMillis() - pl.getNbf() >= pl.getExp() - pl.getNbf();
    }

    public boolean isInvalid(String token, String secret) {
        return this.isInvalid(this.parse(token, secret));
    }

    public boolean isInvalid(Token token) {
        Token.Playload pl = token.getPlayload();
        return System.currentTimeMillis() - pl.getNbf() >= pl.getGra() - pl.getNbf();
    }

    public Token refresh(Token token) {
        Token.Playload pl = token.getPlayload();
        pl.setNbf(System.currentTimeMillis());
        pl.setExp(pl.getNbf() + this.expTime);
        pl.setGra(pl.getNbf() + this.tokeGraTime);
        return token;
    }

    private static class TokenUtil {
        private static final String CONCAT_CHARACTER = ".";

        private TokenUtil() {
        }

        public static String headToBase64(Token.Head head) {
            return TokenUtil.objToBase64(head);
        }

        public static String playloadToBase64(Token.Playload playload) {
            return TokenUtil.objToBase64(playload);
        }

        public static Token.Head base64ToHead(String headBase64) {
            return BeanUtil.toBean(Base64.getDecoder().decode(headBase64.getBytes()), Token.Head.class);
        }

        public static Token.Playload base64ToPlayload(String playBase64) {
            return BeanUtil.toBean(Base64.getDecoder().decode(playBase64), Token.Playload.class);
        }

        public static String secretToBase64(String headBase64, String playloadBase64, String secret) {
            String signature = headBase64 + CONCAT_CHARACTER + playloadBase64 + CONCAT_CHARACTER + secret;
            return Base64.getEncoder().encodeToString(TokenUtil.SHA256Encode(signature));
        }

        private static byte[] SHA256Encode(String str) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                digest.update(str.getBytes());
                return digest.digest();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static String objToBase64(Object obj) {
            return Base64.getEncoder().encodeToString(BeanUtil.toJsonAsBytes(obj));
        }
    }
}

