/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.inzyme.spatiotemporal.common.domain.entity.GpsPoints;
import com.inzyme.spatiotemporal.common.utils.GPSUtil;
import com.inzyme.spatiotemporal.common.utils.StringUtils;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotoolsUtils {
    private static final Logger log = LoggerFactory.getLogger(GeotoolsUtils.class);
    private static GeometryFactory geometryFactory = new GeometryFactory();

    public static boolean withInGeo(double x, double y, String geometry) throws ParseException {
        Coordinate coord = new Coordinate(x, y);
        Point point = geometryFactory.createPoint(coord);
        WKTReader reader = new WKTReader(geometryFactory);
        Polygon polygon = (Polygon)reader.read(geometry);
        return point.within((Geometry)polygon);
    }

    public static String createBuffer(String polyline, int distance) {
        WKTReader reader = new WKTReader();
        Double length = (double)(distance * 180) / Math.PI / 6371000.0;
        try {
            Geometry geometry = reader.read(polyline);
            Geometry bg = geometry.buffer(length.doubleValue());
            return bg.toString();
        }
        catch (ParseException e) {
            log.error("\u7ebf\u751f\u6210\u7f13\u51b2\u533a\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static Geometry createPoineBuffer(String point, int distance) {
        WKTReader reader = new WKTReader();
        Double length = (double)(distance * 180) / Math.PI / 6371000.0;
        try {
            Geometry geometry = reader.read(point);
            Geometry bg = geometry.buffer(length.doubleValue());
            return bg;
        }
        catch (ParseException e) {
            log.error("\u7ebf\u751f\u6210\u7f13\u51b2\u533a\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static boolean withInBuffer(double x, double y, String polyline, int distance) throws ParseException {
        boolean inFlag = false;
        String lineBuffer = GeotoolsUtils.createBuffer(polyline, distance);
        if (!StringUtils.isEmpty(lineBuffer)) {
            inFlag = GeotoolsUtils.withInGeo(x, y, lineBuffer);
        }
        return inFlag;
    }

    public static Geometry geoJsonToGeometry(String geoJson) {
        GeometryJSON json = new GeometryJSON();
        StringReader reader = new StringReader(geoJson);
        try {
            return json.read((Object)reader);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String wktToJson(String wkt) {
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            StringWriter writer = new StringWriter();
            GeometryJSON g = new GeometryJSON(14);
            g.write(geometry, (Object)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getBox(double x, double y, String geometry) throws ParseException {
        Coordinate coord = new Coordinate(x, y);
        Point point = geometryFactory.createPoint(coord);
        WKTReader reader = new WKTReader(geometryFactory);
        Polygon polygon = (Polygon)reader.read(geometry);
        System.out.println(polygon.getBoundary().toText());
    }

    public static Map<String, Object> wktToJson(String wkt, Map<String, Object> map) {
        Object json = null;
        HashMap<String, Object> feature = new HashMap<String, Object>();
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            StringWriter writer = new StringWriter();
            GeometryJSON g = new GeometryJSON(14);
            g.write(geometry, (Object)writer);
            JSONObject jsonObject = JSONObject.parseObject((String)writer.toString());
            feature.put("type", "Feature");
            feature.put("geometry", jsonObject);
            feature.put("properties", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return feature;
    }

    public static GpsPoints changePoint(String type, String points, Integer distance) {
        String[] a;
        GpsPoints gpsPoints = new GpsPoints();
        ArrayList<Coordinate> list84 = new ArrayList<Coordinate>();
        ArrayList<Coordinate> listbd = new ArrayList<Coordinate>();
        for (String str : a = points.split(";")) {
            String[] b = str.split(",");
            listbd.add(new Coordinate(Double.valueOf(b[0]).doubleValue(), Double.valueOf(b[1]).doubleValue()));
            double[] wgs84tobd = GPSUtil.bd09towgs84(Double.valueOf(b[0]), Double.valueOf(b[1]));
            list84.add(new Coordinate(wgs84tobd[0], wgs84tobd[1]));
        }
        if (type.equals("rect")) {
            String[] tt = a[0].split(",");
            listbd.add(new Coordinate(Double.valueOf(tt[0]).doubleValue(), Double.valueOf(tt[1]).doubleValue()));
            double[] wgs84tobd = GPSUtil.bd09towgs84(Double.valueOf(tt[0]), Double.valueOf(tt[1]));
            list84.add(new Coordinate(wgs84tobd[0], wgs84tobd[1]));
        }
        Coordinate[] coordinates84 = list84.toArray(new Coordinate[list84.size()]);
        Coordinate[] coordinatesbd = listbd.toArray(new Coordinate[listbd.size()]);
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        LineString areageometry = null;
        LineString areajson = null;
        if (type.equals("route")) {
            areageometry = gf.createLineString(coordinates84);
            areajson = gf.createLineString(coordinatesbd);
        } else if (type.equals("circle")) {
            Point a84 = gf.createPoint((Coordinate)list84.get(0));
            areageometry = GeotoolsUtils.createPoineBuffer(a84.toString(), distance);
            Point abd = gf.createPoint((Coordinate)listbd.get(0));
            areajson = GeotoolsUtils.createPoineBuffer(abd.toString(), distance);
        } else {
            areageometry = gf.createPolygon(coordinates84);
            areajson = gf.createPolygon(coordinatesbd);
        }
        JSONObject areaJson = new JSONObject(GeotoolsUtils.wktToJson(areajson.toString(), null));
        String areageometryStr = areageometry.toString();
        String point84 = areageometryStr.substring(areageometryStr.lastIndexOf("(") + 1, areageometryStr.lastIndexOf(")") - 1);
        point84 = point84.replace(", ", ";");
        gpsPoints.setGeoString(point84);
        gpsPoints.setAreaJson(areaJson.toJSONString());
        gpsPoints.setAreaGeometry(areageometryStr);
        return gpsPoints;
    }

    public static GpsPoints changePointold(String type, String points, Integer distance) {
        String[] a;
        GpsPoints gpsPoints = new GpsPoints();
        ArrayList<Coordinate> list84 = new ArrayList<Coordinate>();
        ArrayList<Coordinate> listbd = new ArrayList<Coordinate>();
        for (String str : a = points.split(";")) {
            String[] b = str.split(",");
            list84.add(new Coordinate(Double.valueOf(b[0]).doubleValue(), Double.valueOf(b[1]).doubleValue()));
            double[] wgs84tobd = GPSUtil.wgs84tobd09(Double.valueOf(b[0]), Double.valueOf(b[1]));
            listbd.add(new Coordinate(wgs84tobd[0], wgs84tobd[1]));
        }
        Coordinate[] coordinates84 = list84.toArray(new Coordinate[list84.size()]);
        Coordinate[] coordinatesbd = listbd.toArray(new Coordinate[listbd.size()]);
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        LineString areageometry = null;
        LineString areajson = null;
        if (type.equals("route")) {
            areageometry = gf.createLineString(coordinates84);
            areajson = gf.createLineString(coordinatesbd);
        } else if (type.equals("circle")) {
            Point a84 = gf.createPoint((Coordinate)list84.get(0));
            areageometry = GeotoolsUtils.createPoineBuffer(a84.toString(), distance);
            Point abd = gf.createPoint((Coordinate)listbd.get(0));
            areajson = GeotoolsUtils.createPoineBuffer(abd.toString(), distance);
        } else {
            areageometry = gf.createPolygon(coordinates84);
            areajson = gf.createPolygon(coordinatesbd);
        }
        JSONObject areaJson = new JSONObject(GeotoolsUtils.wktToJson(areajson.toString(), null));
        gpsPoints.setGeoString(points);
        gpsPoints.setAreaJson(areaJson.toJSONString());
        gpsPoints.setAreaGeometry(areageometry.toString());
        return gpsPoints;
    }

    public static void main(String[] args) throws ParseException, IOException {
        String wkt84 = "POLYGON ((114.1857961792887 30.475180451015717, 114.18722305359552 30.475167866821753, 114.18722418854787 30.474048443786153, 114.18579731445774 30.474061028021012, 114.1857961792887 30.475180451015717))";
        String wktBaidu = "POLYGON ((114.197879 30.47845, 114.199298 30.47845, 114.199298 30.47733, 114.197879 30.47733, 114.197879 30.47845))";
        System.out.println(GeotoolsUtils.withInGeo(114.1867961792887, 30.475170451015718, wkt84));
        String wkt = "POLYGON((116.400674666119 39.9263885185624, 116.401888188937 39.9264653251907, 116.40191458308 39.9264644052923, 116.401940292158 39.9264583604362, 116.401964330764 39.9264474223171, 116.401985777516 39.9264320101843, 116.402003810378 39.9264127147726, 116.402017738163 39.9263902756596, 116.402027027033 39.9263655529186, 116.40203132095 39.9263394941527, 116.402030455334 39.9263130981735, 116.402024463362 39.9262873767178, 116.402013574702 39.9262633156685, 116.401998206708 39.9262418372665, 116.401978948422 39.9262237647616, 116.401956537999 39.9262097908587, 116.40106401173 39.9257681388544, 116.401051733527 39.9257628043095, 116.400404099472 39.9255188647991, 116.400505604522 39.9248155672974, 116.401509496117 39.9243582356005, 116.40243885151 39.9248543923779, 116.402465636555 39.9248651880585, 116.402494105672 39.9248700352012, 116.402522954132 39.9248687116633, 116.402550859822 39.924861278102, 116.403475276474 39.9245053012346, 116.403497541963 39.9244942752836, 116.403517407624 39.9244793528484, 116.403534199546 39.9244610401499, 116.403547348088 39.9244399584184, 116.403556407207 39.9244168228194, 116.403843308278 39.9234228101547, 116.403847986699 39.9233982388045, 116.403848048309 39.9233732261063, 116.403843490991 39.923348632007, 116.403834471427 39.9233253020621, 116.403821299713 39.9233040383648, 116.403804428699 39.9232855719698, 116.403784438416 39.9232705377596, 116.402748469322 39.9226325464784, 116.402721950409 39.9226199653268, 116.402693338013 39.9226134178896, 116.40266398675 39.9226132141466, 116.402635286217 39.9226193637436, 116.401474467165 39.9230041562204, 116.400920447672 39.9221612172532, 116.401590555625 39.9214491318185, 116.403076167372 39.9218107966693, 116.403078237002 39.9218112832672, 116.404548044731 39.9221446544492, 116.405012918123 39.922698819402, 116.40502272931 39.9227093236039, 116.405596494575 39.9232614675574, 116.405618403578 39.9232785761712, 116.405643354131 39.9232908309238, 116.405670286777 39.9232977114504, 116.405698057893 39.923298925588, 116.405725488256 39.9232944217816, 116.405751413108 39.9232843912732, 116.405774731621 39.923269259981, 116.405794453638 39.9232496704145, 116.405809741716 39.9232264543915, 116.406198836619 39.9224774684664, 116.407366491618 39.9229647496328, 116.407869630367 39.9237981730909, 116.40788545081 39.923819363529, 116.407905101317 39.9238370603836, 116.40792782673 39.9238505835743, 116.407952753724 39.9238594134126, 116.407978924369 39.9238632105727, 116.408005332941 39.9238618291319, 116.408030964575 39.9238553221782, 116.40805483426 39.9238439397702, 116.408076024698 39.9238281193274, 116.408093721552 39.9238084688205, 116.408107244743 39.9237857434076, 116.408116074581 39.9237608164135, 116.408119871742 39.9237346457686, 116.408118490301 39.9237082371961, 116.408111983347 39.9236826055626, 116.408100600939 39.9236587358775, 116.407574655101 39.9227875336489, 116.407557513222 39.9227649153201, 116.407536018611 39.9227463838742, 116.40751112263 39.9227327595232, 116.406188265551 39.9221807100386, 116.406164363285 39.9221732531514, 116.406139494649 39.922170342062, 116.406114516394 39.9221720770603, 116.406090289044 39.9221783983738, 116.406067647257 39.9221890882269, 116.406047371065 39.9222037783434, 116.406030159003 39.9222219626338, 116.406016604045 39.9222430146311, 116.405653525847 39.9229419198536, 116.405214992009 39.9225199113742, 116.404725543239 39.9219364506747, 116.404704497705 39.9219162666766, 116.404679606383 39.9219010768651, 116.404652032359 39.9218915910078, 116.403138951249 39.9215484048697, 116.401578054392 39.9211684122304, 116.401549907571 39.9211646366172, 116.401521594041 39.9211668372509, 116.401494368632 39.9211749166013, 116.401469437951 39.9211885165986, 116.401447906903 39.9212070345029, 116.400650990909 39.9220538715975, 116.400635232264 39.9220741942662, 116.400623616593 39.9220971381535, 116.400616566041 39.9221218694188, 116.400614336842 39.9221474892636, 116.400617010012 39.922173066596, 116.400624488401 39.9221976718693, 116.400636500224 39.9222204108638, 116.401305885269 39.9232388781657, 116.401321630765 39.9232585502398, 116.401340760038 39.9232749509119, 116.401362605669 39.9232875079634, 116.401386405465 39.9232957832794, 116.401411329052 39.9232994881344, 116.401436506848 39.9232984932663, 116.401461060399 39.923292833386, 116.40266051413 39.9228952341467, 116.403555660688 39.923446501267, 116.40331577779 39.9242776122771, 116.402511484911 39.9245873315564, 116.401577759661 39.9240888418346, 116.401554969815 39.9240792442379, 116.401530810931 39.9240739679419, 116.40150609482 39.9240731902459, 116.401481652015 39.9240769372827, 116.401458303869 39.9240850831408, 116.400326692383 39.9246005987639, 116.400303418694 39.9246141561161, 116.40028330233 39.9246320669588, 116.400267145254 39.924653617255, 116.400255591586 39.9246779478765, 116.400249101928 39.9247040888541, 116.400121583912 39.9255876222476, 116.400120369609 39.9256136446509, 116.400124179754 39.925639415231, 116.400132872256 39.9256639729267, 116.400146122945 39.9256864019088, 116.400163437664 39.925705865734, 116.400184170697 39.9257216385386, 116.400207548846 39.9257331321081, 116.400950362131 39.9260129220724, 116.401234714004 39.9261536289388, 116.400550494877 39.9261103231489, 116.40052326896 39.926111356868, 116.400496806061 39.9261178402386, 116.400472185662 39.9261295087891, 116.400450412085 39.9261458865327, 116.400432373524 39.9261663053836, 116.400418805814 39.9261899324103, 116.400410262413 39.9262158038122, 116.400407091826 39.9262428642355, 116.400391137394 39.9272736142777, 116.400393321812 39.9272999685828, 116.400400605727 39.9273253903385, 116.400412709222 39.927348902601, 116.400429167167 39.9273696018072, 116.400449347091 39.9273866924982, 116.400472473493 39.9273995178884, 116.400497657637 39.9274075851052, 116.40052393171 39.9274105841299, 116.400550286015 39.9274083997119, 116.400575707771 39.9274011157969, 116.400599220033 39.9273890123018, 116.400619919239 39.9273725543571, 116.40063700993 39.9273523744324, 116.400649835321 39.9273292480309, 116.400657902537 39.9273040638872, 116.400660901562 39.9272777898139, 116.400674666119 39.9263885185624))";
        Boolean a = GeotoolsUtils.withInGeo(116.40301731682695, 39.921436321582945, wkt);
        System.out.println("withIn:" + a);
    }
}

