/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;

@MappedTypes(value={String.class})
@MappedJdbcTypes(value={JdbcType.OTHER})
public class GeometryTypeHandler
extends BaseTypeHandler<String> {
    static GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    static WKTReader reader = new WKTReader(geometryFactory);

    public void setNonNullParameter(PreparedStatement preparedStatement, int i, String s, JdbcType jdbcType) throws SQLException {
        Geometry geo = null;
        try {
            geo = new WKTReader(new GeometryFactory(new PrecisionModel())).read(s);
            byte[] geometryBytes = new WKBWriter(2, 2, false).write(geo);
            byte[] wkb = new byte[geometryBytes.length + 4];
            wkb[3] = 0;
            wkb[2] = 0;
            wkb[1] = 0;
            wkb[0] = 0;
            System.arraycopy(geometryBytes, 0, wkb, 4, geometryBytes.length);
            preparedStatement.setBytes(i, wkb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNullableResult(ResultSet resultSet, String s) {
        try (InputStream inputStream = resultSet.getBinaryStream(s);){
            String string = this.getGeometryFromInputStream(inputStream);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNullableResult(ResultSet resultSet, int i) {
        try (InputStream inputStream = resultSet.getBinaryStream(i);){
            String string = this.getGeometryFromInputStream(inputStream);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        return "";
    }

    private String getGeometryFromInputStream(InputStream inputStream) throws Exception {
        Geometry dbGeometry = null;
        if (inputStream != null) {
            int i;
            byte[] buffer = new byte[255];
            int bytesRead = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] geometryAsBytes = baos.toByteArray();
            if (geometryAsBytes.length < 5) {
                throw new Exception("\u5750\u6807\u5f02\u5e38");
            }
            byte[] sridBytes = new byte[4];
            System.arraycopy(geometryAsBytes, 0, sridBytes, 0, 4);
            boolean bigEndian = geometryAsBytes[4] == 0;
            int srid = 0;
            if (bigEndian) {
                for (i = 0; i < sridBytes.length; ++i) {
                    srid = (srid << 8) + (sridBytes[i] & 0xFF);
                }
            } else {
                for (i = 0; i < sridBytes.length; ++i) {
                    srid += (sridBytes[i] & 0xFF) << 8 * i;
                }
            }
            WKBReader wkbReader = new WKBReader();
            byte[] wkb = new byte[geometryAsBytes.length - 4];
            System.arraycopy(geometryAsBytes, 4, wkb, 0, wkb.length);
            dbGeometry = wkbReader.read(wkb);
            dbGeometry.setSRID(srid);
        }
        return GeometryTypeHandler.wktToJson(dbGeometry.toString());
    }

    public static String wktToJson(String wkt) {
        try {
            WKTReader reader = new WKTReader();
            Geometry geometry = reader.read(wkt);
            StringWriter writer = new StringWriter();
            GeometryJSON g = new GeometryJSON(14);
            g.write(geometry, (Object)writer);
            return writer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

