/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.inzyme.spatiotemporal.common.annotation.ExcelField;
import com.inzyme.spatiotemporal.common.annotation.ExcelSheet;
import com.inzyme.spatiotemporal.common.utils.MethodUtils;
import com.inzyme.spatiotemporal.common.utils.ObmsConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    private static final Pattern P = Pattern.compile(".0$");

    public static HSSFWorkbook getHSSFWorkbook(String sheetName, String[] title, String[][] values, HSSFWorkbook wb) {
        int i;
        if (wb == null) {
            wb = new HSSFWorkbook();
        }
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFCell cell = null;
        for (i = 0; i < title.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(title[i]);
            cell.setCellStyle(style);
        }
        for (i = 0; i < values.length; ++i) {
            row = sheet.createRow(i + 1);
            for (int j = 0; j < values[i].length; ++j) {
                row.createCell(j).setCellValue(values[i][j]);
            }
        }
        return wb;
    }

    public static <T> List<T> readExcelToEntity(Class<T> clazz, String filePath) {
        try {
            File file = new File(filePath);
            ExcelUtil.checkFile(file.getName());
            Workbook workbook = ExcelUtil.getWorkBoot(new FileInputStream(file), file.getName());
            return ExcelUtil.readExcel(clazz, workbook);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6Excel\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static <T> List<T> readExcelToEntity(Class<T> clazz, MultipartFile file) {
        try {
            ExcelUtil.checkFile(file.getOriginalFilename());
            Workbook workbook = ExcelUtil.getWorkBoot(file.getInputStream(), file.getOriginalFilename());
            return ExcelUtil.readExcel(clazz, workbook);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6Excel\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    private static void checkFile(String fileName) throws Exception {
        if (!(StringUtils.isEmpty((String)fileName) || fileName.endsWith(".xlsx") || fileName.endsWith(".xls"))) {
            throw new Exception("\u4e0d\u662fExcel\u6587\u4ef6\uff01");
        }
    }

    private static Workbook getWorkBoot(InputStream in, String fileName) throws IOException {
        if (fileName.endsWith(".xlsx")) {
            return new XSSFWorkbook(in);
        }
        return new HSSFWorkbook(in);
    }

    private static <T> List<T> readExcel(Class<T> clazz, Workbook workbook) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        ArrayList<T> beans = new ArrayList<T>();
        int sheetNum = workbook.getNumberOfSheets();
        ExcelSheet excelSheet = clazz.getAnnotation(ExcelSheet.class);
        String excelSheetName = excelSheet.value();
        for (int sheetIndex = 0; sheetIndex < sheetNum; ++sheetIndex) {
            Sheet sheet = workbook.getSheetAt(sheetIndex);
            String sheetName = sheet.getSheetName();
            if (!StringUtils.equals((String)excelSheetName, (String)sheetName)) continue;
            int firstRowNum = sheet.getFirstRowNum();
            int lastRowNum = sheet.getLastRowNum();
            Row head = sheet.getRow(firstRowNum);
            if (head == null) continue;
            int firstCellNum = head.getFirstCellNum();
            short lastCellNum = head.getLastCellNum();
            Field[] fields = clazz.getDeclaredFields();
            for (int rowIndex = firstRowNum + 1; rowIndex <= lastRowNum; ++rowIndex) {
                Row dataRow = sheet.getRow(rowIndex);
                if (dataRow == null) continue;
                T instance = clazz.newInstance();
                block2: for (int cellIndex = firstCellNum; cellIndex < lastCellNum; ++cellIndex) {
                    Cell headCell = head.getCell(cellIndex);
                    if (headCell == null) continue;
                    Cell cell = dataRow.getCell(cellIndex);
                    headCell.setCellType(CellType.STRING);
                    String headName = headCell.getStringCellValue().trim();
                    String data = ExcelUtil.getCellStringValue(cell);
                    if (StringUtils.isEmpty((String)headName) || StringUtils.isEmpty((String)data)) continue;
                    for (Field field : fields) {
                        ExcelField excelField = field.getAnnotation(ExcelField.class);
                        if (excelField == null || !headName.equals(excelField.value())) continue;
                        String methodName = MethodUtils.setMethodName(field.getName());
                        Method method = clazz.getMethod(methodName, field.getType());
                        method.invoke(instance, ExcelUtil.convertType(field.getType(), data.trim()));
                        continue block2;
                    }
                }
                beans.add(instance);
            }
        }
        return beans;
    }

    private static String getCellStringValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                Date date = cell.getDateCellValue();
                return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            }
            return ExcelUtil.getRealStringValueOfDouble(cell.getNumericCellValue());
        }
        cell.setCellType(CellType.NUMERIC);
        return cell.getStringCellValue().trim();
    }

    private static String getRealStringValueOfDouble(Double d) {
        String doubleStr = d.toString();
        boolean b = doubleStr.contains("E");
        int indexOfPoint = doubleStr.indexOf(46);
        if (b) {
            int indexOfE = doubleStr.indexOf(69);
            BigInteger xs = new BigInteger(doubleStr.substring(indexOfPoint + BigInteger.ONE.intValue(), indexOfE));
            int pow = Integer.valueOf(doubleStr.substring(indexOfE + BigInteger.ONE.intValue()));
            int xsLen = xs.toByteArray().length;
            int scale = xsLen - pow > 0 ? xsLen - pow : 0;
            doubleStr = String.format("%." + scale + "f", d);
        } else {
            Matcher m = P.matcher(doubleStr);
            if (m.find()) {
                doubleStr = doubleStr.replace(".0", "");
            }
        }
        return doubleStr;
    }

    private static Object convertType(Class clazz, String value) {
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return Integer.valueOf(value);
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return Short.valueOf(value);
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return Byte.valueOf(value);
        }
        if (Character.class == clazz || Character.TYPE == clazz) {
            return Character.valueOf(value.charAt(0));
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return Long.valueOf(value);
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return Float.valueOf(value);
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return Double.valueOf(value);
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return Boolean.valueOf(value.toLowerCase());
        }
        if (BigDecimal.class == clazz) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static Workbook getWorkbook(List list, String type) throws ClassNotFoundException {
        if (StringUtils.equals((String)"xlsx", (String)type)) {
            return ExcelUtil.getXSSFWorkbook(list);
        }
        if (StringUtils.equals((String)"Sheets", (String)type)) {
            return ExcelUtil.getSheets(list);
        }
        return ExcelUtil.getHSSFWorkbook(list);
    }

    private static XSSFWorkbook getSheets(List list) throws ClassNotFoundException {
        XSSFWorkbook wb = new XSSFWorkbook();
        if (CollectionUtils.isEmpty((Collection)list)) {
            wb.createSheet();
            return wb;
        }
        for (int n = 0; n < list.size(); ++n) {
            List l = null;
            Object o = list.get(n);
            if (o != null) {
                l = (List)o;
            }
            if (CollectionUtils.isEmpty(l)) {
                wb.createSheet();
                continue;
            }
            Class<?> c = l.get(0).getClass();
            ExcelSheet excelSheet = c.getAnnotation(ExcelSheet.class);
            String tagging = excelSheet.tagging();
            XSSFSheet sheet = wb.createSheet(excelSheet.value());
            int index = 0;
            int indexRow = 0;
            XSSFRow xssfRow = null;
            XSSFCell xssfCell = null;
            ArrayList classList = new ArrayList();
            ArrayList<Integer> classListHeadIndex = new ArrayList<Integer>();
            classList.add(c);
            classListHeadIndex.add(0);
            while (classList.size() != 0) {
                int indexTemp = classList.size();
                xssfRow = sheet.createRow(indexRow++);
                for (int k = 0; k < indexTemp; ++k) {
                    Field[] fields = ((Class)classList.remove(0)).getDeclaredFields();
                    int indexCell = (Integer)classListHeadIndex.remove(0);
                    for (int i = 0; i < fields.length; ++i) {
                        ExcelField excelField = fields[i].getAnnotation(ExcelField.class);
                        if (excelField == null) continue;
                        xssfCell = xssfRow.createCell(indexCell++);
                        xssfCell.setCellValue(excelField.value());
                    }
                    index = indexCell;
                }
            }
            XSSFRow xssfRowData = null;
            for (int i = 0; i < l.size(); ++i) {
                xssfRowData = sheet.createRow(indexRow++);
                Object object = l.get(i);
                Field[] fieldDatas = object.getClass().getDeclaredFields();
                int temp = 0;
                XSSFCellStyle style = wb.createCellStyle();
                for (int j = 0; j < fieldDatas.length; ++j) {
                    ExcelField excelField = fieldDatas[j].getAnnotation(ExcelField.class);
                    if (excelField == null) continue;
                    xssfCell = xssfRowData.createCell(temp++);
                    Object value = ExcelUtil.getFieldValueByFieldName(fieldDatas[j].getName(), object);
                    ExcelUtil.setValue(xssfCell, value);
                    xssfCell.setCellStyle((CellStyle)style);
                    if (!StringUtils.equals((String)tagging, (String)fieldDatas[j].getName()) || !ObmsConstants.COLOR_MAP.containsKey(value)) continue;
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(ObmsConstants.COLOR_MAP.get(value));
                }
            }
            ExcelUtil.setAutoSizeColumn(sheet, index);
        }
        return wb;
    }

    private static HSSFWorkbook getHSSFWorkbook(List list) throws ClassNotFoundException {
        if (CollectionUtils.isEmpty((Collection)list)) {
            HSSFWorkbook wb = new HSSFWorkbook();
            wb.createSheet();
            return wb;
        }
        Class<?> c = list.get(0).getClass();
        HashMap cglab = new HashMap();
        HSSFWorkbook wb = new HSSFWorkbook();
        ExcelSheet excelSheet = c.getAnnotation(ExcelSheet.class);
        HSSFSheet sheet = wb.createSheet(excelSheet.value());
        int index = 0;
        int indexRow = 0;
        HSSFRow hssfRow = null;
        HSSFCell headCell = null;
        ArrayList classList = new ArrayList();
        ArrayList<Integer> classListHeadIndex = new ArrayList<Integer>();
        classList.add(c);
        classListHeadIndex.add(0);
        while (classList.size() != 0) {
            int indexTemp = classList.size();
            hssfRow = sheet.createRow(indexRow++);
            for (int k = 0; k < indexTemp; ++k) {
                Field[] fields = ((Class)classList.remove(0)).getDeclaredFields();
                int indexCell = (Integer)classListHeadIndex.remove(0);
                for (int i = 0; i < fields.length; ++i) {
                    ExcelField excelField = fields[i].getAnnotation(ExcelField.class);
                    if (excelField == null) continue;
                    headCell = hssfRow.createCell(indexCell++);
                    headCell.setCellValue(excelField.value());
                    if (excelField.className().equals("")) continue;
                    Class<?> classTemp = Class.forName(excelField.className());
                    classList.add(classTemp);
                    classListHeadIndex.add(indexCell - 1);
                    int count = ExcelUtil.countLeaf(classTemp);
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(indexRow - 1, indexRow - 1, indexCell - 1, indexCell + count - 2);
                    sheet.addMergedRegion(cellRangeAddress);
                    indexCell = indexCell + count - 1;
                }
                index = indexCell;
            }
        }
        HSSFRow hssfRowData = null;
        for (int i = 0; i < list.size(); ++i) {
            hssfRowData = sheet.createRow(indexRow++);
            Object object = list.get(i);
            Field[] fieldDatas = object.getClass().getDeclaredFields();
            int temp = 0;
            HSSFCell hssfCell = null;
            for (int j = 0; j < fieldDatas.length; ++j) {
                ExcelField excelField = fieldDatas[j].getAnnotation(ExcelField.class);
                if (excelField == null) continue;
                if (!excelField.className().equals("")) {
                    int k;
                    ArrayList<String> valueList = new ArrayList<String>();
                    Object o = ExcelUtil.getFieldValueByFieldName(fieldDatas[j].getName(), object);
                    if (o == null) {
                        for (k = 0; k < ExcelUtil.countLeaf(fieldDatas[j].getType().getClass()); ++k) {
                            valueList.add("");
                        }
                    } else {
                        ExcelUtil.valueLeaf(valueList, o);
                    }
                    for (k = 0; k < valueList.size(); ++k) {
                        hssfCell = hssfRowData.createCell(temp++);
                        Object value = valueList.get(k);
                        ExcelUtil.setValue(hssfCell, value);
                    }
                    continue;
                }
                hssfCell = hssfRowData.createCell(temp++);
                Object value = ExcelUtil.getFieldValueByFieldName(fieldDatas[j].getName(), object);
                ExcelUtil.setValue(hssfCell, value);
            }
        }
        ExcelUtil.setAutoSizeColumn(sheet, index);
        return wb;
    }

    private static XSSFWorkbook getXSSFWorkbook(List list) throws ClassNotFoundException {
        if (CollectionUtils.isEmpty((Collection)list)) {
            XSSFWorkbook wb = new XSSFWorkbook();
            wb.createSheet();
            return wb;
        }
        Class<?> c = list.get(0).getClass();
        HashMap cglab = new HashMap();
        XSSFWorkbook wb = new XSSFWorkbook();
        ExcelSheet excelSheet = c.getAnnotation(ExcelSheet.class);
        String tagging = excelSheet.tagging();
        XSSFSheet sheet = wb.createSheet(excelSheet.value());
        int index = 0;
        int indexRow = 0;
        XSSFRow xssfRow = null;
        XSSFCell xssfCell = null;
        ArrayList classList = new ArrayList();
        ArrayList<Integer> classListHeadIndex = new ArrayList<Integer>();
        classList.add(c);
        classListHeadIndex.add(0);
        while (classList.size() != 0) {
            int indexTemp = classList.size();
            xssfRow = sheet.createRow(indexRow++);
            for (int k = 0; k < indexTemp; ++k) {
                Field[] fields = ((Class)classList.remove(0)).getDeclaredFields();
                int indexCell = (Integer)classListHeadIndex.remove(0);
                for (int i = 0; i < fields.length; ++i) {
                    ExcelField excelField = fields[i].getAnnotation(ExcelField.class);
                    if (excelField == null) continue;
                    xssfCell = xssfRow.createCell(indexCell++);
                    xssfCell.setCellValue(excelField.value());
                    if (excelField.className().equals("")) continue;
                    Class<?> classTemp = Class.forName(excelField.className());
                    classList.add(classTemp);
                    classListHeadIndex.add(indexCell - 1);
                    int count = ExcelUtil.countLeaf(classTemp);
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(indexRow - 1, indexRow - 1, indexCell - 1, indexCell + count - 2);
                    sheet.addMergedRegion(cellRangeAddress);
                    indexCell = indexCell + count - 1;
                }
                index = indexCell;
            }
        }
        XSSFRow xssfRowData = null;
        for (int i = 0; i < list.size(); ++i) {
            xssfRowData = sheet.createRow(indexRow++);
            Object object = list.get(i);
            Field[] fieldDatas = object.getClass().getDeclaredFields();
            int temp = 0;
            XSSFCellStyle style = wb.createCellStyle();
            for (int j = 0; j < fieldDatas.length; ++j) {
                ExcelField excelField = fieldDatas[j].getAnnotation(ExcelField.class);
                if (excelField == null) continue;
                if (!excelField.className().equals("")) {
                    int k;
                    ArrayList<String> valueList = new ArrayList<String>();
                    Object o = ExcelUtil.getFieldValueByFieldName(fieldDatas[j].getName(), object);
                    if (o == null) {
                        for (k = 0; k < ExcelUtil.countLeaf(fieldDatas[j].getType().getClass()); ++k) {
                            valueList.add("");
                        }
                    } else {
                        ExcelUtil.valueLeaf(valueList, o);
                    }
                    for (k = 0; k < valueList.size(); ++k) {
                        xssfCell = xssfRowData.createCell(temp++);
                        Object value = valueList.get(k);
                        ExcelUtil.setValue(xssfCell, value);
                    }
                    continue;
                }
                xssfCell = xssfRowData.createCell(temp++);
                Object value = ExcelUtil.getFieldValueByFieldName(fieldDatas[j].getName(), object);
                ExcelUtil.setValue(xssfCell, value);
                xssfCell.setCellStyle((CellStyle)style);
            }
        }
        ExcelUtil.setAutoSizeColumn(sheet, index);
        return wb;
    }

    private static void setValue(HSSFCell hssfCell, Object value) {
        if (value instanceof String) {
            hssfCell.setCellValue(value.toString());
        } else if (value instanceof Integer) {
            hssfCell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Double) {
            hssfCell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            hssfCell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            hssfCell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Short) {
            hssfCell.setCellValue((double)((Short)value).shortValue());
        } else if (value instanceof Long) {
            hssfCell.setCellValue(value.toString());
        } else if (value instanceof Character) {
            hssfCell.setCellValue((double)((Character)value).charValue());
        }
    }

    private static void setValue(XSSFCell xssfCell, Object value) {
        if (value instanceof String) {
            xssfCell.setCellValue(value.toString());
        } else if (value instanceof Integer) {
            xssfCell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Double) {
            xssfCell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            xssfCell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof Float) {
            xssfCell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Short) {
            xssfCell.setCellValue((double)((Short)value).shortValue());
        } else if (value instanceof Long) {
            xssfCell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Character) {
            xssfCell.setCellValue((double)((Character)value).charValue());
        }
    }

    private static void setAutoSizeColumn(HSSFSheet hssfSheet, int size) {
        for (int i = 0; i < size; ++i) {
            hssfSheet.autoSizeColumn(i, true);
        }
    }

    private static void setAutoSizeColumn(XSSFSheet xssfSheet, int size) {
        for (int i = 0; i < size; ++i) {
            xssfSheet.autoSizeColumn(i, true);
        }
    }

    private static int countLeaf(Class c) throws ClassNotFoundException {
        Field[] fields = c.getDeclaredFields();
        int ans = 0;
        for (int i = 0; i < fields.length; ++i) {
            ExcelField excelField = fields[i].getAnnotation(ExcelField.class);
            if (excelField == null) continue;
            if (!excelField.className().equals("")) {
                ans += ExcelUtil.countLeaf(Class.forName(excelField.className()));
                continue;
            }
            ++ans;
        }
        return ans;
    }

    private static void valueLeaf(List list, Object o) {
        Class<?> c = o.getClass();
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ExcelField excelField = fields[i].getAnnotation(ExcelField.class);
            if (excelField == null) continue;
            if (!excelField.className().equals("")) {
                ExcelUtil.valueLeaf(list, ExcelUtil.getFieldValueByFieldName(fields[i].getName(), o));
                continue;
            }
            list.add(ExcelUtil.getFieldValueByFieldName(fields[i].getName(), o));
        }
    }

    public static Map getMap(List list) {
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<String> obExcelFieldList = new ArrayList<String>();
        ArrayList<String> obobFieldValueList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Object ob = list.get(i);
            Class<?> c = ob.getClass();
            Field[] fields = c.getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                String tempName = fields[j].getName();
                if (tempName.equals("obExcelField")) {
                    obExcelFieldList.add((String)ExcelUtil.getFieldValueByFieldName(fields[j].getName(), ob));
                }
                if (!tempName.equals("obFieldValue")) continue;
                obobFieldValueList.add((String)ExcelUtil.getFieldValueByFieldName(fields[j].getName(), ob));
            }
        }
        map.put("obExcelField", obExcelFieldList);
        map.put("obFieldValue", obobFieldValueList);
        return map;
    }

    private static Object getFieldValueByFieldName(String fieldName, Object object) {
        Class<?> c = object.getClass();
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            String s = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Method method = c.getMethod("get" + s, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void buildExcelDocument(String fileName, Workbook wb, HttpServletResponse response) {
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "utf-8"));
            response.flushBuffer();
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

