/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class DoubleUtils {
    private static final long serialVersionUID = -3345205828566485102L;
    private static final Integer DEF_DIV_SCALE = 2;

    public static Double add(Double[] values) {
        BigDecimal value = BigDecimal.ZERO;
        for (Double val : values) {
            value.add(new BigDecimal(Double.toString(val)));
        }
        return value.doubleValue();
    }

    public static double sub(Double value1, Double value2) {
        BigDecimal b1 = new BigDecimal(Double.toString(value1));
        BigDecimal b2 = new BigDecimal(Double.toString(value2));
        return b1.subtract(b2).doubleValue();
    }

    public static Double mul(Double value1, Double value2) {
        BigDecimal b1 = new BigDecimal(Double.toString(value1));
        BigDecimal b2 = new BigDecimal(Double.toString(value2));
        return b1.multiply(b2).doubleValue();
    }

    public static Double divide(Double dividend, Double divisor) {
        return DoubleUtils.divide(dividend, divisor, DEF_DIV_SCALE);
    }

    public static Double divide(Double dividend, Double divisor, Integer scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(dividend));
        BigDecimal b2 = new BigDecimal(Double.toString(divisor));
        return b1.divide(b2, (int)scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double round(double value, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(value));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, RoundingMode.HALF_UP).doubleValue();
    }
}

