/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtil {
    private static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    private static String ymd = "yyyy-MM-dd";
    public static SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
    private static String year = "yyyy";
    private static String month = "MM";
    private static String day = "dd";
    public static SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat(ymdhms);
    public static SimpleDateFormat yearSDF = new SimpleDateFormat(year);
    public static SimpleDateFormat monthSDF = new SimpleDateFormat(month);
    public static SimpleDateFormat daySDF = new SimpleDateFormat(day);
    public static SimpleDateFormat yyyyMMddHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat yyyyMMddHH_NOT_ = new SimpleDateFormat("yyyyMMdd");
    public static long DATEMM = 86400L;

    public static String getCurrentTime() {
        return yyyyMMddHHmmss.format(new Date());
    }

    public static Date getSysTime() {
        return DateUtil.stringToDate(DateUtil.getCurrentTime(), ymdhms);
    }

    public static Date getSysDate() {
        return DateUtil.stringToDate(DateUtil.getCurrentTime(), ymd);
    }

    public static String getCurrentDate() {
        return ymdSDF.format(new Date());
    }

    public static String getYesterdayYYYYMMDD() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMddHHmmss.parse(str + " 00:00:00");
            return yyyyMMdd.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getStrDate(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getCurrentYear() {
        return yearSDF.format(new Date());
    }

    public static String getCurrentMonth() {
        return monthSDF.format(new Date());
    }

    public static String getCurrentDay() {
        return daySDF.format(new Date());
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMdd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getTodateString() {
        String str = yyyyMMddHH_NOT_.format(new Date());
        return str;
    }

    public static String getYesterdayString() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        String str = yyyyMMddHH_NOT_.format(date);
        return str;
    }

    public static Date getYesterDayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static Date getYesterDay24Hour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(10, 23);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefer(String givedTime, long interval, String format_Date_Sign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format_Date_Sign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(format_Date_Sign).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tomorrow;
    }

    public static long stringToLong(String date, String format) {
        try {
            SimpleDateFormat sf = new SimpleDateFormat(format);
            return sf.parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return null;
        }
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate(endTime, Integer.parseInt(day + ""), isEndTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return 0;
        }
        long day = 0L;
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefer(endTime, DATEMM, ymd);
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public static String timestamp2String(Timestamp timestamp) {
        return yyyyMMddHHmmss.format(timestamp);
    }

    public static String long2strDate(Long millSec, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = new Date(millSec);
        return sdf.format(date);
    }
}

