/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service
public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);
    private static final String PREFIX_LOG = "\u3010\u81ea\u5b9a\u4e49DB\u5de5\u5177\u3011";
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> excuteQuerySql(String sql) {
        log.info("\u3010\u81ea\u5b9a\u4e49DB\u5de5\u5177\u3011\u6267\u884c\u67e5\u8be2sql:" + sql);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        PreparedStatement pst = null;
        SqlSession session = this.getSqlSession();
        ResultSet result = null;
        try {
            pst = session.getConnection().prepareStatement(sql);
            result = pst.executeQuery();
            ResultSetMetaData md = result.getMetaData();
            int columnCount = md.getColumnCount();
            while (result.next()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    rowData.put(md.getColumnName(i), result.getObject(i));
                }
                list.add(rowData);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.closeSqlSession(session);
        }
        return list;
    }

    public SqlSession getSqlSession() {
        return SqlSessionUtils.getSqlSession((SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory(), (ExecutorType)this.sqlSessionTemplate.getExecutorType(), (PersistenceExceptionTranslator)this.sqlSessionTemplate.getPersistenceExceptionTranslator());
    }

    public void closeSqlSession(SqlSession session) {
        SqlSessionUtils.closeSqlSession((SqlSession)session, (SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory());
    }
}

