/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationUtils {
    private static final Logger log = LoggerFactory.getLogger(CommunicationUtils.class);
    private static int CONNECTION_TIME_OUT = 10000;
    private static int READ_TIME_OUT = 300000;

    public static String postHttps(String url, String content, Map<String, String> header) throws Exception {
        URL console = new URL(url);
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        HttpsURLConnection conn = (HttpsURLConnection)console.openConnection();
        conn.setSSLSocketFactory(sc.getSocketFactory());
        conn.setHostnameVerifier(new TrustAnyHostnameVerifier());
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(CONNECTION_TIME_OUT);
        conn.setReadTimeout(READ_TIME_OUT);
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        if (header != null) {
            for (String key : header.keySet()) {
                conn.setRequestProperty(key, header.get(key));
            }
        }
        conn.connect();
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.write(content.getBytes("utf-8"));
        out.flush();
        out.close();
        InputStream is = conn.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, "utf-8");
        if (is != null) {
            StringBuffer temp = new StringBuffer();
            int len = 0;
            while ((len = isr.read()) != -1) {
                temp.append((char)len);
            }
            isr.close();
            is.close();
            return temp.toString();
        }
        return null;
    }

    public static String postHttp(String url, String content, Map<String, String> header) throws IOException {
        URL console = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)console.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(CONNECTION_TIME_OUT);
        conn.setReadTimeout(READ_TIME_OUT);
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        if (header != null) {
            for (String key : header.keySet()) {
                conn.setRequestProperty(key, header.get(key));
            }
        }
        conn.connect();
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        if (content != null) {
            out.write(content.getBytes("UTF-8"));
        }
        out.flush();
        out.close();
        int code = conn.getResponseCode();
        InputStream is = conn.getInputStream();
        InputStreamReader isr = null;
        isr = new InputStreamReader(is, "UTF-8");
        log.info("InputStreamReader encoding:::{}", (Object)isr.getEncoding());
        if (is != null) {
            int len;
            StringBuilder temp = new StringBuilder();
            while ((len = isr.read()) != -1) {
                temp.append((char)len);
            }
            isr.close();
            is.close();
            return temp.toString();
        }
        return null;
    }

    public static byte[] getUTF8BytesFromGBKString(String gbkStr) {
        int n = gbkStr.length();
        byte[] utfBytes = new byte[3 * n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            char m = gbkStr.charAt(i);
            if (m < '\u0080' && m >= '\u0000') {
                utfBytes[k++] = (byte)m;
                continue;
            }
            utfBytes[k++] = (byte)(0xE0 | m >> 12);
            utfBytes[k++] = (byte)(0x80 | m >> 6 & 0x3F);
            utfBytes[k++] = (byte)(0x80 | m & 0x3F);
        }
        if (k < utfBytes.length) {
            byte[] tmp = new byte[k];
            System.arraycopy(utfBytes, 0, tmp, 0, k);
            return tmp;
        }
        return utfBytes;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("systemid", "s04");
        header.put("domain", "s04");
        String url = " https://\u7efc\u5408\u96c6\u6210\u5e73\u53f0\u8bbf\u95ee\u5730\u5740/interfaces/verify";
        String content = "{\r\n\"type\":\"add\",\r\n\"users\":[\r\n    {\"username\":\"huangml\",\"nickname\":\"hml\",\"password\":\"123456\",\"orgName\":\"\u4e91\u5357\u7701\u6863\u6848\u9986\"},\r\n    {\"username\":\"zhangQ\",\"nickname\":\"zq\",\"password\":\"123456\",\"orgName\":\"\u4e91\u5357\u7701\u6863\u6848\u9986\"}\r\n    ]\r\n}";
        CommunicationUtils.postHttps("https://IP:port/interfaces/syncuser", content, header);
        CommunicationUtils.postHttp("https://IP:port/interfaces/syncuser", content, header);
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

