/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.inzyme.spatiotemporal.common.utils.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class CalcUtils {
    public static int toInt(Object obj) {
        Integer rtn = 0;
        try {
            if (null != obj) {
                rtn = Integer.valueOf(obj.toString());
            }
        }
        catch (Exception ex) {
            rtn = 0;
        }
        return rtn;
    }

    public static double toDouble(Object obj) {
        double rtn = 0.0;
        try {
            if (null != obj) {
                rtn = Double.valueOf(obj.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static long toLong(Object str) {
        Long rtn = 0L;
        try {
            rtn = Long.valueOf(str.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static Float toFloat(Object str) {
        Float rtn = Float.valueOf(0.0f);
        try {
            rtn = Float.valueOf(str.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double subtract(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return CalcUtils.mul(v1, v2, 2);
    }

    public static double mul(double v1, double v2, int n) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return CalcUtils.round(b1.multiply(b2).doubleValue(), n);
    }

    public static double div(double v1, double v2) {
        return CalcUtils.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        if (v2 == 0.0) {
            return 0.0;
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static int trunc(double value) {
        BigDecimal big = new BigDecimal(Double.toString(value)).setScale(0, 4);
        return big.intValue();
    }

    public static float round(float value, int inum) {
        double num = Math.pow(10.0, inum);
        return (float)((double)Math.round((double)value * num) / num);
    }

    public static double round(double value, int inum) {
        double num = Math.pow(10.0, inum);
        return (double)Math.round(value * num) / num;
    }

    public static boolean between(double lower, double upper, double value) {
        return lower <= value && value <= upper;
    }

    public static boolean between1(double lower, double upper, double value) {
        return lower <= value && value < upper;
    }

    public static String alarmLayer(Boolean aStatus, Boolean bStatus, Boolean cStatus) {
        return aStatus != false ? "A" : (bStatus != false ? "B" : "C");
    }

    public static int isAlarmUpgrade(String newLayer, String oldLayer) {
        char ol;
        int flg = -1;
        if (StringUtils.isEmpty(newLayer) || StringUtils.isEmpty(oldLayer) || newLayer.codePointCount(0, newLayer.length()) != 1 || oldLayer.codePointCount(0, oldLayer.length()) != 1) {
            return flg;
        }
        char nl = newLayer.charAt(0);
        flg = 100 - nl > 100 - (ol = oldLayer.charAt(0)) ? 1 : (100 - nl == 100 - ol ? 0 : -1);
        return flg;
    }

    private static double calcHoursBetween(int cfgStartHour, int cfgEndHour, Date redisDate, Date msgDate) {
        double hoursBetweenDates = 0.0;
        try {
            if (redisDate.before(msgDate)) {
                Calendar redisCalendar = Calendar.getInstance();
                redisCalendar.setTime(redisDate);
                int redisHour = redisCalendar.get(11);
                int redisYearDay = redisCalendar.get(6);
                Calendar msgCalendar = Calendar.getInstance();
                msgCalendar.setTime(msgDate);
                int msgHour = msgCalendar.get(11);
                int msgYearDay = msgCalendar.get(6);
                long diffInMilliseconds = Math.abs(msgDate.getTime() - redisDate.getTime());
                double realHours = CalcUtils.div(diffInMilliseconds, 3600000.0, 2);
                int days = (int)realHours / 24;
                boolean redisRange = false;
                boolean msgRange = false;
                if (cfgStartHour <= redisHour && redisHour < cfgEndHour) {
                    redisRange = true;
                }
                if (cfgStartHour <= msgHour && msgHour < cfgEndHour) {
                    msgRange = true;
                }
                if (redisRange) {
                    redisCalendar.set(11, cfgEndHour);
                    redisCalendar.set(12, 0);
                    redisCalendar.set(13, 0);
                }
                if (msgRange) {
                    msgCalendar.set(11, cfgStartHour);
                    msgCalendar.set(12, 0);
                    msgCalendar.set(13, 0);
                }
                if (redisYearDay == msgYearDay) {
                    if (redisRange && msgRange) {
                        return hoursBetweenDates;
                    }
                    if (redisHour < cfgStartHour && msgHour >= cfgEndHour) {
                        ++days;
                    }
                } else if (msgYearDay - redisYearDay == days) {
                    if (redisRange && msgRange) {
                        --days;
                    }
                    if (redisHour < cfgStartHour && msgHour >= cfgEndHour) {
                        ++days;
                    }
                } else {
                    if (redisHour >= cfgEndHour && msgHour >= cfgEndHour) {
                        ++days;
                    }
                    if (redisHour < cfgStartHour && msgHour < cfgStartHour) {
                        ++days;
                    }
                }
                long fixDiffInMilliseconds = Math.abs(msgCalendar.getTimeInMillis() - redisCalendar.getTimeInMillis());
                double fixRealHours = CalcUtils.div(fixDiffInMilliseconds, 3600000.0, 2);
                hoursBetweenDates = fixRealHours - (double)(days * (cfgEndHour - 1));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hoursBetweenDates;
    }

    private static double calcHoursBetweenJump(int cfgJumpStartHour, int cfgJumpEndHour, Date redisDate, Date msgDate) {
        double hoursBetweenDates = 0.0;
        try {
            if (redisDate.before(msgDate)) {
                Calendar redisCalendar = Calendar.getInstance();
                redisCalendar.setTime(redisDate);
                int redisHour = redisCalendar.get(11);
                int redisYearDay = redisCalendar.get(6);
                Calendar msgCalendar = Calendar.getInstance();
                msgCalendar.setTime(msgDate);
                int msgHour = msgCalendar.get(11);
                int msgYearDay = msgCalendar.get(6);
                int interval = 24 - cfgJumpStartHour + cfgJumpEndHour;
                if (redisYearDay == msgYearDay) {
                    if (redisHour >= 0 && redisHour < cfgJumpEndHour) {
                        if (msgHour >= 0 && msgHour < cfgJumpEndHour) {
                            return hoursBetweenDates;
                        }
                        redisCalendar.set(11, cfgJumpEndHour);
                        redisCalendar.set(12, 0);
                        redisCalendar.set(13, 0);
                    }
                    if (msgHour >= cfgJumpStartHour && msgHour < 24) {
                        if (redisHour >= cfgJumpStartHour && redisHour < 24) {
                            return hoursBetweenDates;
                        }
                        msgCalendar.set(11, cfgJumpStartHour);
                        msgCalendar.set(12, 0);
                        msgCalendar.set(13, 0);
                    }
                    long fixDiffInMilliseconds = Math.abs(msgCalendar.getTimeInMillis() - redisCalendar.getTimeInMillis());
                    hoursBetweenDates = CalcUtils.div(fixDiffInMilliseconds, 3600000.0, 2);
                } else {
                    double calcHour = 0.0;
                    Calendar tmpCalendar = Calendar.getInstance();
                    for (int i = redisYearDay; i <= msgYearDay; ++i) {
                        long fixDiffInMilliseconds;
                        if (i == redisYearDay) {
                            if (redisHour >= 0 && redisHour < cfgJumpEndHour) {
                                calcHour += (double)interval;
                                continue;
                            }
                            if (redisHour < cfgJumpEndHour || redisHour >= cfgJumpStartHour) continue;
                            tmpCalendar.setTime(redisDate);
                            tmpCalendar.set(11, cfgJumpStartHour);
                            tmpCalendar.set(12, 0);
                            tmpCalendar.set(13, 0);
                            fixDiffInMilliseconds = Math.abs(tmpCalendar.getTimeInMillis() - redisCalendar.getTimeInMillis());
                            calcHour += CalcUtils.div(fixDiffInMilliseconds, 3600000.0, 2);
                            continue;
                        }
                        if (i == msgYearDay) {
                            if (msgHour >= 0 && msgHour < cfgJumpEndHour) continue;
                            if (msgHour >= cfgJumpEndHour && msgHour < cfgJumpStartHour) {
                                tmpCalendar.setTime(msgDate);
                                tmpCalendar.set(11, cfgJumpEndHour);
                                tmpCalendar.set(12, 0);
                                tmpCalendar.set(13, 0);
                                fixDiffInMilliseconds = Math.abs(msgCalendar.getTimeInMillis() - tmpCalendar.getTimeInMillis());
                                calcHour += CalcUtils.div(fixDiffInMilliseconds, 3600000.0, 2);
                                continue;
                            }
                            calcHour += (double)interval;
                            continue;
                        }
                        calcHour += (double)interval;
                    }
                    hoursBetweenDates = calcHour;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hoursBetweenDates;
    }

    public static double calcHours4Exclude(int configStartHour, int configEndHour, Date startDate, Date messageDate) {
        if (configStartHour < configEndHour) {
            return CalcUtils.round(CalcUtils.calcHoursBetween(configStartHour, configEndHour, startDate, messageDate), 2);
        }
        return CalcUtils.round(CalcUtils.calcHoursBetweenJump(configStartHour, configEndHour, startDate, messageDate), 2);
    }
}

