/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    public static Map<String, Object> toMap(Object obj) {
        return BeanUtil.toMap(obj, null);
    }

    public static Map<String, Object> toMap(String key, Object obj) {
        HashMap<String, Object> empty = new HashMap<String, Object>();
        empty.put(key, obj);
        return empty;
    }

    public static Map<String, Object> toMap(Object obj, String ... excludeFields) {
        HashMap<String, Object> empty = new HashMap<String, Object>();
        if (Objects.isNull(obj)) {
            return empty;
        }
        return BeanUtil.beanToMap(obj, excludeFields);
    }

    public static <T> T addFeildValueInOrginal(T original, T target) {
        if (Objects.isNull(original) || Objects.isNull(target)) {
            return original;
        }
        return BeanUtil.addFeildValueInOrginal0(original, target, false);
    }

    public static <T> T switchFeildValueInOrginal(T original, T target) {
        if (Objects.isNull(original) || Objects.isNull(target)) {
            return original;
        }
        return BeanUtil.addFeildValueInOrginal0(original, target, true);
    }

    public static String toJson(Object obj) {
        try {
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            log.warn("---- > switch object to json string is failed ,and that object is : " + obj.toString(), (Throwable)e);
            return null;
        }
    }

    public static JSONObject toJosnObject(String json) {
        return JSON.parseObject((String)json);
    }

    public static byte[] toJsonAsBytes(Object obj) {
        String json = BeanUtil.toJson(obj);
        return Objects.isNull(json) ? new byte[]{} : json.getBytes();
    }

    public static JSONArray toJosnArray(String json) {
        return JSON.parseArray((String)json);
    }

    public static String deepExtractData(String json, String field) {
        JSONObject jo = BeanUtil.toJosnObject(json);
        Set keys = jo.keySet();
        if (keys.contains(field)) {
            String result = jo.get((Object)field).toString();
            return result.startsWith("\"") && result.endsWith("\"") ? result.substring(1, result.length() - 1) : result;
        }
        for (String key : keys) {
            try {
                String s = BeanUtil.deepExtractData(jo.get((Object)key).toString(), field);
                if (s == null) continue;
                return s;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static <T> T toBean(String json, Class<? extends T> cls) {
        try {
            return (T)JSON.parseObject((String)json, cls);
        }
        catch (Exception e) {
            log.warn("---- > switch json string to bean is failed ,and that object class is : " + cls + " ,and that json string is : " + json, (Throwable)e);
            return null;
        }
    }

    public static <T> T toBean(byte[] json, Class<? extends T> cls) {
        return BeanUtil.toBean(new String(json), cls);
    }

    public static <T> T toBean(byte[] json, Charset charset, Class<? extends T> cls) {
        try {
            return BeanUtil.toBean(new String(json, charset.name()), cls);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("---- > switch json string to bean is failed ,and that object class is : " + cls + " ,and that json string is : " + json + " ;cause is is no given character : " + charset, (Throwable)e);
            return null;
        }
    }

    private static <T> T addFeildValueInOrginal0(T original, T target, boolean isSwitch) {
        Field[] originalFields = BeanUtil.getDeclaredFields(original);
        Map<String, Object> targetFields = BeanUtil.beanToMap(target, null);
        if (Objects.isNull(originalFields)) {
            return original;
        }
        for (Field f : originalFields) {
            f.setAccessible(true);
            Object originalValue = null;
            try {
                originalValue = f.get(original);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (!isSwitch && !Objects.isNull(originalValue)) continue;
            String name = f.getName();
            Class<?> fieldType = f.getType();
            Object val = targetFields.get(name);
            if (val == null || !fieldType.isAssignableFrom(val.getClass()) && !fieldType.getName().equals(val.getClass().getName())) continue;
            try {
                f.set(original, val);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return original;
    }

    private static Field[] getDeclaredFields(Object original) {
        return original.getClass().getDeclaredFields();
    }

    private static Map<String, Object> beanToMap(Object obj, String[] excludeFields) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> cls = obj.getClass();
        Field[] fields = cls.getDeclaredFields();
        if (Objects.isNull(fields) || fields.length == 0) {
            return result;
        }
        for (Field field : fields) {
            field.setAccessible(true);
            String name = field.getName();
            if (CollectionUtils.containsAny(Arrays.asList(excludeFields), (Object[])new String[]{name})) continue;
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            result.put(name, value);
        }
        return result;
    }

    public static boolean isFeildNull(Object obj) {
        return BeanUtil.isFeildNull(obj, "");
    }

    public static boolean isFeildNull(Object obj, String excludeField) {
        return BeanUtil.isFeildNull(obj, new String[]{excludeField});
    }

    public static boolean isFeildNull(Object obj, String[] excludeFields) {
        if (obj != null) {
            Map<String, Object> fields = BeanUtil.beanToMap(obj, null);
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                if (CollectionUtils.containsAny(Arrays.asList(excludeFields), (Object[])new String[]{entry.getKey()}) || entry.getValue() == null) continue;
                return false;
            }
        }
        return true;
    }
}

