/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.utils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AdDateUtils {
    public static Map<Integer, WeekData> weeks(YearMonth yearMonth) {
        LocalDate start = LocalDate.now().with(yearMonth).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate end = LocalDate.now().with(yearMonth).with(TemporalAdjusters.lastDayOfMonth());
        Map<Integer, WeekData> map = Stream.iterate(start, localDate -> localDate.plusDays(1L)).limit(ChronoUnit.DAYS.between(start, end) + 1L).collect(Collectors.groupingBy(localDate -> localDate.get(WeekFields.of(DayOfWeek.MONDAY, 1).weekOfMonth()), Collectors.collectingAndThen(Collectors.toList(), WeekData::new)));
        return map;
    }

    public static Date getMonthDate(Date startDate, int month) {
        LocalDateTime localDateTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusMonths(month);
        Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static Map<Integer, WeekData> weeksNow(LocalDate localDate) {
        Map<Integer, WeekData> weekDataMap = AdDateUtils.weeks(YearMonth.of(localDate.getYear(), localDate.getMonth()));
        HashMap<Integer, WeekData> map = new HashMap<Integer, WeekData>();
        int now = 0;
        for (Integer integer : weekDataMap.keySet()) {
            if (weekDataMap.get((Object)integer).start.compareTo(localDate) > 0) continue;
            now = integer - 1;
        }
        if (weekDataMap.get(now) != null) {
            map.put(now, weekDataMap.get(now));
        } else {
            if (map.get(0) == null) {
                weekDataMap = AdDateUtils.weeks(YearMonth.of(localDate.plusMonths(-1L).getYear(), localDate.plusMonths(-1L).getMonth()));
            }
            if (weekDataMap.get(5) != null) {
                map.put(5, weekDataMap.get(5));
            } else {
                map.put(4, weekDataMap.get(4));
            }
        }
        return map;
    }

    public static Map<Integer, WeekData> weeksNowDq(LocalDate localDate) {
        Map<Integer, WeekData> weekDataMap = AdDateUtils.weeks(YearMonth.of(localDate.getYear(), localDate.getMonth()));
        HashMap<Integer, WeekData> map = new HashMap<Integer, WeekData>();
        int now = 0;
        for (Integer integer : weekDataMap.keySet()) {
            if (weekDataMap.get((Object)integer).start.compareTo(localDate) > 0) continue;
            now = integer;
        }
        map.put(now, weekDataMap.get(now));
        return map;
    }

    public static void main(String[] args) throws Exception {
        Map<Integer, WeekData> weekData = AdDateUtils.weeksNowDq(LocalDate.now().minusDays(7L));
        System.out.println(weekData);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate date = LocalDate.of(2021, 3, 14);
        LocalDate firstDay = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        System.out.println(Integer.valueOf(firstDay.format(formatter)));
        System.out.println(Integer.valueOf(lastDay.format(formatter)));
    }

    public static class WeekData {
        public LocalDate start;
        public LocalDate end;

        public WeekData(List<LocalDate> localDates) {
            this.start = localDates.get(0);
            this.end = localDates.get(localDates.size() - 1);
        }

        public String toString() {
            return this.start + "   " + this.end;
        }
    }
}

