/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.properties;

import com.inzy.common.constant.RegisterConstants;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class ServiceDiscover {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public String discover(String serviceName) {
        String url = null;
        String path = RegisterConstants.SERVICE_REGISTER_KEY + serviceName + ":";
        Set<String> keys = this.scan(path);
        if (null != keys && !keys.isEmpty()) {
            url = ServiceDiscover.getRandomServiceUrl(keys).substring(path.length());
        }
        return url;
    }

    private Set<String> scan(String matchKey) {
        Set keys = (Set)this.redisTemplate.execute(connection -> {
            HashSet<String> keysTmp = new HashSet<String>();
            Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().match(matchKey + "*").count(100L).build());
            while (cursor.hasNext()) {
                keysTmp.add(new String((byte[])cursor.next()));
            }
            return keysTmp;
        });
        return keys;
    }

    private static <E> E getRandomServiceUrl(Set<E> set) {
        return set.stream().skip(new Random().nextInt(set.size())).findFirst().orElse(null);
    }
}

