/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;

public class UserTypeConverter
implements Converter<Integer> {
    public Class<?> supportJavaTypeKey() {
        return Integer.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Integer convertToJavaData(ReadConverterContext<?> context) throws Exception {
        String cellStr = context.getReadCellData().getStringValue();
        if (StrUtil.isEmpty((CharSequence)cellStr)) {
            return null;
        }
        if ("\u90e8\u95e8".equals(cellStr)) {
            return 1;
        }
        if ("\u8fd0\u8f93\u516c\u53f8".equals(cellStr)) {
            return 2;
        }
        if ("\u53f8\u673a".equals(cellStr)) {
            return 3;
        }
        return null;
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Integer> context) throws Exception {
        Integer cellValue = (Integer)context.getValue();
        if (cellValue == null) {
            return new WriteCellData("");
        }
        if (cellValue == 1) {
            return new WriteCellData("\u90e8\u95e8");
        }
        if (cellValue == 2) {
            return new WriteCellData("\u8fd0\u8f93\u516c\u53f8");
        }
        if (cellValue == 3) {
            return new WriteCellData("\u53f8\u673a");
        }
        return new WriteCellData("");
    }
}

