/*
 * Decompiled with CFR 0.152.
 */
package com.inzyme.spatiotemporal.common.aspect;

import com.alibaba.fastjson.JSON;
import com.inzyme.spatiotemporal.common.annotation.RequestLimit;
import com.inzyme.spatiotemporal.common.utils.RequestUtil;
import com.inzyme.spatiotemporal.common.utils.ResponseUtils;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestLimitAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLimitAspect.class);
    @Resource
    private RedisTemplate<String, Integer> redisTemplate;
    private static final String IPLIMIT_KEY = "ipLimit:";

    @Around(value="@annotation(com.inzyme.spatiotemporal.common.annotation.RequestLimit)")
    public Object before(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        String methodName = signature.getDeclaringTypeName() + "." + signature.getName();
        log.debug("\u62e6\u622a\u65b9\u6cd5{}", (Object)methodName);
        RequestLimit limit = method.getAnnotation(RequestLimit.class);
        ServletRequestAttributes attribute = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attribute == null) {
            log.warn(this.getClass().getName() + "\u53ea\u80fd\u7528\u4e8eweb controller\u65b9\u6cd5");
            return pjp.proceed();
        }
        HttpServletRequest request = attribute.getRequest();
        String ip = new RequestUtil(request).getIp();
        String key = IPLIMIT_KEY + methodName + ":" + ip;
        Integer count = (Integer)this.redisTemplate.opsForValue().get((Object)key);
        int nowCount = count == null ? 0 : count;
        String key2 = "md:ipLimit:" + methodName + ":" + ip;
        Boolean flag = this.redisTemplate.hasKey((Object)key2);
        this.redisTemplate.opsForValue().set((Object)key2, (Object)0, 3L, TimeUnit.SECONDS);
        if (flag.booleanValue()) {
            assert (attribute.getResponse() != null);
            log.info("\u8bbf\u95ee\u9891\u7e41\u88ab\u62d2\u7edd\u8bbf\u95ee\uff0cip:{}\uff0cmethod:{}", (Object)ip, (Object)signature.getName());
            ResponseUtils.renderJson(attribute.getResponse(), JSON.toJSONString((Object)new ReturnVO(ReturnEnum.FAILED, (Object)"\u8bbf\u95ee\u9891\u7e41")));
        }
        return pjp.proceed();
    }
}

