package com.inzyme.spatiotemporal.common.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.ListUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author Q.JI
 * @ClassName: StatUtils
 * @Description: StatUtils
 * @date 2022年7月13日 下午4:10:33
 * @since JDK 1.8
 */

@Slf4j
public class StatUtils {

    /**
     * 将时间戳转换成指定时区时间
     *
     * @param timestampStr 时间戳
     * @param dateFormat   格式 如：yyyy-MM-dd
     * @param offsetFormat 时区偏移（单位：小时） 如：-8
     * @return yyyy-MM-dd
     */
    public static String timestampToDateFormat(Long timestampStr, String dateFormat, Integer offsetFormat) {
        // 出参
        timestampStr = timestampConvert(timestampStr);
        Date date = null;
        try {
            date = new Date(timestampStr);
        } catch (Exception e) {
            log.info("##### 时间转换失败 cause : " + e);
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        // 转换成标准时间
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(Calendar.HOUR, calendar.get(Calendar.HOUR) + offsetFormat);
        Date newDate = calendar.getTime();
        // 获取本地时区
        /*TimeZone timeZone = calendar.getTimeZone();
        sdf.setTimeZone(timeZone);*/

        return sdf.format(newDate);
    }

    /**
     * 将时间戳转换成指定时区时间
     *
     * @param timestampStr 时间戳
     * @param dateFormat   格式 如：yyyy-MM-dd
     * @return yyyy-MM-dd
     */
    public static String timestampToDateFormat(Long timestampStr, String dateFormat) {
        return timestampToDateFormat(timestampStr, dateFormat, 8);
    }


    // 各种时间戳转换为毫秒
    private static Long timestampConvert(Long timestamp) {
        String string = timestamp.toString();
        switch (string.length()) {
            case 10:
                timestamp = timestamp * 1000;
                break;
            case 16:
                timestamp = timestamp / 1000;
                break;
            case 19:
                timestamp = timestamp / 1000 / 1000;
                break;
        }
        return timestamp;
    }


    /**
     * 转字符串
     *
     * @param obj
     * @return
     */
    public static String nvl(Object obj) {
        return (obj == null) ? "" : obj.toString();
    }

    /**
     * @param obj
     * @return int
     * @Title: toInt
     * @Description: toInt
     */
    public static int toInt(Object obj) {
        Integer rtn = 0;
        try {
            if (null != obj) {
                rtn = Integer.valueOf(obj.toString());
            }
        } catch (Exception ex) {
            rtn = 0;
        }
        return rtn;
    }

    /**
     * @param obj
     * @return double
     * @Title: toDouble
     * @Description: toDouble
     */
    public static double toDouble(Object obj) {
        double rtn = 0d;
        try {
            if (null != obj) {
                rtn = Double.valueOf(obj.toString());
            }
        } catch (Exception ex) {
        }
        return rtn;
    }

    /**
     * @param str
     * @return long
     * @Title: toLong
     * @Description: toLong
     */
    public static long toLong(Object str) {
        Long rtn = 0l;
        try {
            rtn = Long.valueOf(str.toString());
        } catch (Exception ex) {
        }
        return rtn;
    }

    /**
     * @param str
     * @return Float
     * @Title: toFloat
     * @Description: toFloat
     */
    public static Float toFloat(Object str) {
        Float rtn = 0f;
        try {
            rtn = Float.valueOf(str.toString());
        } catch (Exception ex) {
        }
        return rtn;
    }


    /**
     * @param time:
     * @return boolean
     * @author
     * @Description: 当前时间一小时内对比
     */
    public static boolean comparisonHour(long time) {
        return System.currentTimeMillis() - timestampConvert(time) < 3600000;
    }

    public static List<String> getDateString(Integer num) {
        String today = StatUtils.timestampToDateFormat(System.currentTimeMillis(), "yyyy-MM-dd");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<String> putDates = new ArrayList<>();
        try {


            if (num <= 0) {
                return putDates;
            }
            for (int i = 0; i < num; i++) {
                Date date = sdf.parse(today);
                Calendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                calendar.add(Calendar.DATE, -i);
                date = calendar.getTime();
                String putDate = sdf.format(date);
                putDates.add(putDate);
            }
            return putDates;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return putDates;
    }

    /**
     * list进行拆分分页
     */
    public static List partitionList(List list, int pageNum, int pageSize) {

        if (list.isEmpty()) {
            return list;
        }
        if (pageNum <= 1) {
            pageNum = 1;
        }

        // 分页拆分集合,每页大小为5条记录
        List<List<Object>> pageList = ListUtils.partition(list, pageSize);
        if (pageList.size() <= pageNum - 1) {
            pageNum = pageList.size();
        }
        return pageList.get(pageNum - 1);
    }

    /**
     * 将Date对象转换为yyyy-MM-dd HH:mm:ss字符串
     *
     * @param d
     * @return
     */
    public static String dateToStr(Date d, String type) {
        // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat(type);
        String dateNowStr = sdf.format(d);
        return dateNowStr;
    }

    /**
     * @param
     * @return
     */
    public static Integer compareInt(Object a, Object b) {

        if (toInt(a) >= toInt(b)) {
            return toInt(a);
        } else {
            return toInt(b);
        }

    }

    /**
     * @param
     * @return
     */
    public static Float compareFloat(Object a, Object b) {

        if (toFloat(a) >= toFloat(b)) {
            return toFloat(a);
        } else {
            return toFloat(b);
        }
    }

    /**
     * @param
     * @return
     */
    public static List<String> gethours() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        List<String> hours = new ArrayList<>();
        for (int i = hour; i >= 0; i--) {
            hours.add(String.valueOf(toInt(dateToStr(new Date(), "yyyyMMddHH")) - i));
        }


        return hours;
    }

    /**
     * @param
     * @return
     */
    public static List<String> getMins() {
        List<String> minites = new ArrayList<>();

        long end = toLong(dateToStr(new Date(), "yyyyMMddHHmm"));
        long start = toLong(dateToStr(new Date(), "yyyyMMddHH")) * 100;
        while (start <= end) {
            minites.add(String.valueOf(start));
            start++;
        }

        return minites;
    }

    /**
     * 获取中位数
     *
     * @param arr
     * @return
     */
    public static Float getMedianNum(Float[] arr) {

        //边界值
        if (arr == null || arr.length == 0) {
            return null;
        }

        //考虑到arr长度为1时交由下面业务逻辑处理耗时也耗空间，此处做提前判断时间复杂度也才多O(1)
        if (arr.length == 1) {
            return arr[0];
        }

        // 默认是小顶堆，大顶堆为new PriorityQueue<>(Collections.reverseOrder())
        PriorityQueue<Float> minPQ = new PriorityQueue<>();
        int length = arr.length;
        int k = length / 2 + 1;

        for (int i = 0; i < k; i++) {
            minPQ.add(arr[i]);
        }
        for (int i = k; i < length; i++) {
            if (minPQ.peek() < arr[i]) {
                minPQ.poll();
                minPQ.add(arr[i]);
            }
        }
        if (length % 2 == 0) {
            return (minPQ.poll() + minPQ.peek()) / 2;
        } else {
            return minPQ.peek().floatValue();
        }
    }

    public static void main(String[] args) {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(Calendar.HOUR, -23);
        System.out.println(StatUtils.dateToStr(calendar2.getTime(), "yyyyMMddHH"));
    }

}
