package com.inzyme.spatiotemporal.common.utils;
 
import java.util.HashSet;
import java.util.Set;
 
/**
 * @author wyf
 * @date 2022/7/12 10:12
 */
public class SetUtil {
 
    /**
     * 取交集（取两个集合中都存在的元素）
     * @return
     */
    public static Set<String> intersectionSet(Set<String> setA, Set<String> setB){
        Set<String> resSet = new HashSet<>();
        resSet.addAll(setA);
        resSet.retainAll(setB);
        return resSet;
    }
 
    /**
     * 取差集（取存在一个集合中，但不存在于另外一个集合中的元素）
     * @return 存在A集合，不存在B集合的数据
     */
    public static Set<String> differenceSet(Set<String> setA, Set<String> setB){
        Set<String> resSet = new HashSet<>();
        resSet.addAll(setA);
        resSet.removeAll(setB);
        return resSet;
    }
 
    /**
     * 取并集（取两个集合中全部的元素，这个很简单，都把他们添加进去就行）
     * @return
     */
    public static Set<String> unionSet(Set<String> setA, Set<String> setB){
        Set<String> resSet = new HashSet<>();
        resSet.addAll(setA);
        resSet.addAll(setB);
        return resSet;
    }
}